/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.binder.engine.statement.ddl;

import com.cedarsoftware.util.CaseInsensitiveMap;
import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Multimap;
import org.apache.shardingsphere.infra.binder.engine.segment.dml.from.context.TableSegmentBinderContext;
import org.apache.shardingsphere.infra.binder.engine.segment.dml.from.type.SimpleTableSegmentBinder;
import org.apache.shardingsphere.infra.binder.engine.statement.SQLStatementBinder;
import org.apache.shardingsphere.infra.binder.engine.statement.SQLStatementBinderContext;
import org.apache.shardingsphere.infra.binder.engine.statement.SQLStatementCopyUtils;
import org.apache.shardingsphere.sql.parser.statement.core.segment.generic.table.SimpleTableSegment;
import org.apache.shardingsphere.sql.parser.statement.core.statement.SQLStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.type.ddl.table.AlterTableStatement;

public final class AlterTableStatementBinder
implements SQLStatementBinder<AlterTableStatement> {
    @Override
    public AlterTableStatement bind(AlterTableStatement sqlStatement, SQLStatementBinderContext binderContext) {
        LinkedHashMultimap tableBinderContexts = LinkedHashMultimap.create();
        SimpleTableSegment boundTable = SimpleTableSegmentBinder.bind(sqlStatement.getTable(), binderContext, (Multimap<CaseInsensitiveMap.CaseInsensitiveString, TableSegmentBinderContext>)tableBinderContexts);
        SimpleTableSegment boundRenameTable = sqlStatement.getRenameTable().map(arg_0 -> AlterTableStatementBinder.lambda$bind$0(binderContext, (Multimap)tableBinderContexts, arg_0)).orElse(null);
        return this.copy(sqlStatement, boundTable, boundRenameTable);
    }

    private AlterTableStatement copy(AlterTableStatement sqlStatement, SimpleTableSegment boundTable, SimpleTableSegment boundRenameTable) {
        AlterTableStatement result = new AlterTableStatement(sqlStatement.getDatabaseType());
        result.setTable(boundTable);
        result.setRenameTable(boundRenameTable);
        sqlStatement.getConvertTableDefinition().ifPresent(arg_0 -> ((AlterTableStatement)result).setConvertTableDefinition(arg_0));
        result.getAddColumnDefinitions().addAll(sqlStatement.getAddColumnDefinitions());
        result.getModifyColumnDefinitions().addAll(sqlStatement.getModifyColumnDefinitions());
        result.getChangeColumnDefinitions().addAll(sqlStatement.getChangeColumnDefinitions());
        result.getDropColumnDefinitions().addAll(sqlStatement.getDropColumnDefinitions());
        result.getAddConstraintDefinitions().addAll(sqlStatement.getAddConstraintDefinitions());
        result.getValidateConstraintDefinitions().addAll(sqlStatement.getValidateConstraintDefinitions());
        result.getModifyConstraintDefinitions().addAll(sqlStatement.getModifyConstraintDefinitions());
        result.getDropConstraintDefinitions().addAll(sqlStatement.getDropConstraintDefinitions());
        result.getDropIndexDefinitions().addAll(sqlStatement.getDropIndexDefinitions());
        result.getRenameColumnDefinitions().addAll(sqlStatement.getRenameColumnDefinitions());
        result.getRenameIndexDefinitions().addAll(sqlStatement.getRenameIndexDefinitions());
        sqlStatement.getModifyCollectionRetrieval().ifPresent(arg_0 -> ((AlterTableStatement)result).setModifyCollectionRetrieval(arg_0));
        sqlStatement.getDropPrimaryKeyDefinition().ifPresent(arg_0 -> ((AlterTableStatement)result).setDropPrimaryKeyDefinition(arg_0));
        SQLStatementCopyUtils.copyAttributes((SQLStatement)sqlStatement, (SQLStatement)result);
        return result;
    }

    private static /* synthetic */ SimpleTableSegment lambda$bind$0(SQLStatementBinderContext binderContext, Multimap tableBinderContexts, SimpleTableSegment optional) {
        return SimpleTableSegmentBinder.bind(optional, binderContext, (Multimap<CaseInsensitiveMap.CaseInsensitiveString, TableSegmentBinderContext>)tableBinderContexts);
    }
}

