/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.binder.engine.statement.dcl;

import com.cedarsoftware.util.CaseInsensitiveMap;
import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.shardingsphere.infra.binder.engine.segment.dml.from.context.TableSegmentBinderContext;
import org.apache.shardingsphere.infra.binder.engine.segment.dml.from.type.SimpleTableSegmentBinder;
import org.apache.shardingsphere.infra.binder.engine.statement.SQLStatementBinder;
import org.apache.shardingsphere.infra.binder.engine.statement.SQLStatementBinderContext;
import org.apache.shardingsphere.infra.binder.engine.statement.SQLStatementCopyUtils;
import org.apache.shardingsphere.sql.parser.statement.core.segment.generic.table.SimpleTableSegment;
import org.apache.shardingsphere.sql.parser.statement.core.statement.SQLStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.type.dcl.RevokeStatement;

public final class RevokeStatementBinder
implements SQLStatementBinder<RevokeStatement> {
    @Override
    public RevokeStatement bind(RevokeStatement sqlStatement, SQLStatementBinderContext binderContext) {
        LinkedHashMultimap tableBinderContexts = LinkedHashMultimap.create();
        ArrayList<SimpleTableSegment> boundTables = new ArrayList<SimpleTableSegment>();
        for (SimpleTableSegment each : sqlStatement.getTables()) {
            boundTables.add(SimpleTableSegmentBinder.bind(each, binderContext, (Multimap<CaseInsensitiveMap.CaseInsensitiveString, TableSegmentBinderContext>)tableBinderContexts));
        }
        return this.copy(sqlStatement, boundTables);
    }

    private RevokeStatement copy(RevokeStatement sqlStatement, Collection<SimpleTableSegment> tables) {
        RevokeStatement result;
        if (tables.equals(sqlStatement.getTables())) {
            return sqlStatement;
        }
        try {
            result = (RevokeStatement)sqlStatement.getClass().getDeclaredConstructor(sqlStatement.getDatabaseType().getClass()).newInstance(sqlStatement.getDatabaseType());
        }
        catch (ReflectiveOperationException ex) {
            result = new RevokeStatement(sqlStatement.getDatabaseType());
        }
        result.getTables().clear();
        result.getTables().addAll(tables);
        SQLStatementCopyUtils.copyAttributes((SQLStatement)sqlStatement, (SQLStatement)result);
        return result;
    }
}

