/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.binder.engine.segment.dml.from.type;

import com.cedarsoftware.util.CaseInsensitiveMap;
import com.google.common.collect.Multimap;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.Optional;
import lombok.Generated;
import org.apache.shardingsphere.database.connector.core.metadata.database.enums.QuoteCharacter;
import org.apache.shardingsphere.database.connector.core.metadata.database.metadata.DialectDatabaseMetaData;
import org.apache.shardingsphere.database.connector.core.type.DatabaseType;
import org.apache.shardingsphere.database.connector.core.type.DatabaseTypeRegistry;
import org.apache.shardingsphere.database.exception.core.exception.syntax.database.NoDatabaseSelectedException;
import org.apache.shardingsphere.database.exception.core.exception.syntax.database.UnknownDatabaseException;
import org.apache.shardingsphere.database.exception.core.exception.syntax.table.TableExistsException;
import org.apache.shardingsphere.infra.binder.engine.segment.dml.from.context.TableSegmentBinderContext;
import org.apache.shardingsphere.infra.binder.engine.segment.dml.from.context.type.SimpleTableSegmentBinderContext;
import org.apache.shardingsphere.infra.binder.engine.segment.util.AlterTableMetadataCheckUtils;
import org.apache.shardingsphere.infra.binder.engine.segment.util.SubqueryTableBindUtils;
import org.apache.shardingsphere.infra.binder.engine.statement.SQLStatementBinderContext;
import org.apache.shardingsphere.infra.exception.ShardingSpherePreconditions;
import org.apache.shardingsphere.infra.exception.kernel.metadata.DuplicateIndexException;
import org.apache.shardingsphere.infra.exception.kernel.metadata.IndexNotFoundException;
import org.apache.shardingsphere.infra.exception.kernel.metadata.SchemaNotFoundException;
import org.apache.shardingsphere.infra.exception.kernel.metadata.TableNotFoundException;
import org.apache.shardingsphere.infra.metadata.database.schema.manager.SystemSchemaManager;
import org.apache.shardingsphere.infra.metadata.database.schema.model.ShardingSphereColumn;
import org.apache.shardingsphere.infra.metadata.database.schema.model.ShardingSphereSchema;
import org.apache.shardingsphere.infra.metadata.database.schema.model.ShardingSphereTable;
import org.apache.shardingsphere.sql.parser.statement.core.enums.TableSourceType;
import org.apache.shardingsphere.sql.parser.statement.core.segment.ddl.column.ColumnDefinitionSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.ddl.table.RenameTableDefinitionSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.column.ColumnSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.item.ColumnProjectionSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.item.ProjectionSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.generic.OwnerSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.generic.PivotSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.generic.bound.ColumnSegmentBoundInfo;
import org.apache.shardingsphere.sql.parser.statement.core.segment.generic.bound.TableSegmentBoundInfo;
import org.apache.shardingsphere.sql.parser.statement.core.segment.generic.table.SimpleTableSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.generic.table.TableNameSegment;
import org.apache.shardingsphere.sql.parser.statement.core.statement.type.ddl.index.CreateIndexStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.type.ddl.index.DropIndexStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.type.ddl.table.AlterTableStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.type.ddl.table.CreateTableStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.type.ddl.table.DropTableStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.type.ddl.table.RenameTableStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.type.ddl.view.AlterViewStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.type.ddl.view.CreateViewStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.type.ddl.view.DropViewStatement;
import org.apache.shardingsphere.sql.parser.statement.core.value.identifier.IdentifierValue;

public final class SimpleTableSegmentBinder {
    public static SimpleTableSegment bind(SimpleTableSegment segment, SQLStatementBinderContext binderContext, Multimap<CaseInsensitiveMap.CaseInsensitiveString, TableSegmentBinderContext> tableBinderContexts) {
        binderContext.getPivotColumnNames().addAll(segment.getPivot().map(PivotSegment::getPivotColumnNames).orElse(Collections.emptyList()));
        IdentifierValue databaseName = SimpleTableSegmentBinder.getDatabaseName(segment, binderContext);
        Optional<IdentifierValue> schemaName = SimpleTableSegmentBinder.getSchemaName(segment, binderContext, databaseName);
        IdentifierValue tableName = segment.getTableName().getIdentifier();
        Optional<ShardingSphereSchema> schema = schemaName.map(identifierValue -> binderContext.getMetaData().getDatabase(databaseName.getValue()).getSchema(identifierValue.getValue()));
        SimpleTableSegmentBinder.checkTableExists(binderContext, schema.orElse(null), tableName.getValue());
        SimpleTableSegmentBinder.checkTableMetadata(binderContext, schema.orElse(null), schemaName.map(IdentifierValue::getValue).orElse(null), tableName.getValue());
        tableBinderContexts.put((Object)CaseInsensitiveMap.CaseInsensitiveString.of((String)segment.getAliasName().orElseGet(() -> ((IdentifierValue)tableName).getValue())), (Object)SimpleTableSegmentBinder.createSimpleTableBinderContext(segment, schema.orElse(null), databaseName, schemaName.orElse(null), binderContext));
        TableNameSegment tableNameSegment = new TableNameSegment(segment.getTableName().getStartIndex(), segment.getTableName().getStopIndex(), tableName);
        tableNameSegment.setTableBoundInfo(new TableSegmentBoundInfo(databaseName, (IdentifierValue)schemaName.orElse(null)));
        SimpleTableSegment result = new SimpleTableSegment(tableNameSegment);
        segment.getOwner().ifPresent(arg_0 -> ((SimpleTableSegment)result).setOwner(arg_0));
        segment.getAliasSegment().ifPresent(arg_0 -> ((SimpleTableSegment)result).setAlias(arg_0));
        return result;
    }

    private static IdentifierValue getDatabaseName(SimpleTableSegment segment, SQLStatementBinderContext binderContext) {
        DialectDatabaseMetaData dialectDatabaseMetaData = new DatabaseTypeRegistry(binderContext.getSqlStatement().getDatabaseType()).getDialectDatabaseMetaData();
        Optional<String> owner = dialectDatabaseMetaData.getSchemaOption().getDefaultSchema().isPresent() ? segment.getOwner().flatMap(OwnerSegment::getOwner) : segment.getOwner();
        IdentifierValue result = new IdentifierValue(owner.map(optional -> optional.getIdentifier().getValue()).orElse(binderContext.getCurrentDatabaseName()));
        ShardingSpherePreconditions.checkNotNull((Object)result.getValue(), NoDatabaseSelectedException::new);
        ShardingSpherePreconditions.checkState((boolean)binderContext.getMetaData().containsDatabase(result.getValue()), () -> new UnknownDatabaseException(result.getValue()));
        return result;
    }

    private static Optional<IdentifierValue> getSchemaName(SimpleTableSegment segment, SQLStatementBinderContext binderContext, IdentifierValue databaseName) {
        Optional<IdentifierValue> result = SimpleTableSegmentBinder.getSchemaName(segment, binderContext);
        result.ifPresent(identifierValue -> ShardingSpherePreconditions.checkState((boolean)binderContext.getMetaData().getDatabase(databaseName.getValue()).containsSchema(identifierValue.getValue()), () -> new SchemaNotFoundException(identifierValue.getValue())));
        return result;
    }

    private static Optional<IdentifierValue> getSchemaName(SimpleTableSegment segment, SQLStatementBinderContext binderContext) {
        if (segment.getOwner().isPresent()) {
            return Optional.ofNullable(((OwnerSegment)segment.getOwner().get()).getIdentifier());
        }
        DatabaseType databaseType = binderContext.getSqlStatement().getDatabaseType();
        DatabaseTypeRegistry databaseTypeRegistry = new DatabaseTypeRegistry(databaseType);
        DialectDatabaseMetaData dialectDatabaseMetaData = databaseTypeRegistry.getDialectDatabaseMetaData();
        Optional defaultSystemSchema = dialectDatabaseMetaData.getSchemaOption().getDefaultSystemSchema();
        if (defaultSystemSchema.isPresent() && SystemSchemaManager.isSystemTable((String)databaseType.getType(), (String)((String)defaultSystemSchema.get()), (String)segment.getTableName().getIdentifier().getValue())) {
            return Optional.of(new IdentifierValue((String)defaultSystemSchema.get()));
        }
        return Optional.of(new IdentifierValue(databaseTypeRegistry.getDefaultSchemaName(binderContext.getCurrentDatabaseName())));
    }

    private static void checkTableExists(SQLStatementBinderContext binderContext, ShardingSphereSchema schema, String tableName) {
        if (binderContext.getSqlStatement() instanceof CreateTableStatement && SimpleTableSegmentBinder.isCreateTable(((CreateTableStatement)binderContext.getSqlStatement()).getTable(), tableName)) {
            ShardingSpherePreconditions.checkState((binderContext.getHintValueContext().isSkipMetadataValidate() || ((CreateTableStatement)binderContext.getSqlStatement()).isIfNotExists() || null == schema || !schema.containsTable(tableName) ? 1 : 0) != 0, () -> new TableExistsException(tableName));
            return;
        }
        if (binderContext.getSqlStatement() instanceof AlterTableStatement && SimpleTableSegmentBinder.isRenameTable((AlterTableStatement)binderContext.getSqlStatement(), tableName)) {
            ShardingSpherePreconditions.checkState((binderContext.getHintValueContext().isSkipMetadataValidate() || null == schema || !schema.containsTable(tableName) ? 1 : 0) != 0, () -> new TableExistsException(tableName));
            return;
        }
        if (binderContext.getSqlStatement() instanceof DropTableStatement) {
            ShardingSpherePreconditions.checkState((((DropTableStatement)binderContext.getSqlStatement()).isIfExists() || null != schema && schema.containsTable(tableName) ? 1 : 0) != 0, () -> new TableNotFoundException(tableName));
            return;
        }
        if (binderContext.getSqlStatement() instanceof RenameTableStatement && SimpleTableSegmentBinder.isRenameTable((RenameTableStatement)binderContext.getSqlStatement(), tableName)) {
            ShardingSpherePreconditions.checkState((binderContext.getHintValueContext().isSkipMetadataValidate() || null == schema || !schema.containsTable(tableName) ? 1 : 0) != 0, () -> new TableExistsException(tableName));
            return;
        }
        if (binderContext.getSqlStatement() instanceof CreateViewStatement && SimpleTableSegmentBinder.isCreateTable(((CreateViewStatement)binderContext.getSqlStatement()).getView(), tableName)) {
            ShardingSpherePreconditions.checkState((binderContext.getHintValueContext().isSkipMetadataValidate() || ((CreateViewStatement)binderContext.getSqlStatement()).isReplaceView() || null == schema || !schema.containsTable(tableName) ? 1 : 0) != 0, () -> new TableExistsException(tableName));
            return;
        }
        if (binderContext.getSqlStatement() instanceof AlterViewStatement && SimpleTableSegmentBinder.isRenameView((AlterViewStatement)binderContext.getSqlStatement(), tableName)) {
            ShardingSpherePreconditions.checkState((binderContext.getHintValueContext().isSkipMetadataValidate() || null == schema || !schema.containsTable(tableName) ? 1 : 0) != 0, () -> new TableExistsException(tableName));
            return;
        }
        if (binderContext.getSqlStatement() instanceof DropViewStatement) {
            ShardingSpherePreconditions.checkState((((DropViewStatement)binderContext.getSqlStatement()).isIfExists() || null != schema && schema.containsTable(tableName) ? 1 : 0) != 0, () -> new TableNotFoundException(tableName));
            return;
        }
        if ("DUAL".equalsIgnoreCase(tableName)) {
            return;
        }
        if (null != schema && SystemSchemaManager.isSystemTable((String)schema.getName(), (String)tableName)) {
            return;
        }
        if (null != tableName && binderContext.getExternalTableBinderContexts().containsKey((Object)CaseInsensitiveMap.CaseInsensitiveString.of((String)tableName))) {
            return;
        }
        if (binderContext.getCommonTableExpressionsSegmentsUniqueAliases().contains(tableName)) {
            return;
        }
        ShardingSpherePreconditions.checkState((null != schema && schema.containsTable(tableName) ? 1 : 0) != 0, () -> new TableNotFoundException(tableName));
    }

    private static boolean isCreateTable(SimpleTableSegment simpleTableSegment, String tableName) {
        return simpleTableSegment.getTableName().getIdentifier().getValue().equalsIgnoreCase(tableName);
    }

    private static boolean isRenameTable(AlterTableStatement alterTableStatement, String tableName) {
        return alterTableStatement.getRenameTable().isPresent() && ((SimpleTableSegment)alterTableStatement.getRenameTable().get()).getTableName().getIdentifier().getValue().equalsIgnoreCase(tableName);
    }

    private static boolean isRenameTable(RenameTableStatement renameTableStatement, String tableName) {
        for (RenameTableDefinitionSegment each : renameTableStatement.getRenameTables()) {
            if (!each.getRenameTable().getTableName().getIdentifier().getValue().equalsIgnoreCase(tableName)) continue;
            return true;
        }
        return false;
    }

    private static boolean isRenameView(AlterViewStatement alterViewStatement, String tableName) {
        return alterViewStatement.getRenameView().isPresent() && ((SimpleTableSegment)alterViewStatement.getRenameView().get()).getTableName().getIdentifier().getValue().equalsIgnoreCase(tableName);
    }

    private static void checkTableMetadata(SQLStatementBinderContext binderContext, ShardingSphereSchema schema, String schemaName, String tableName) {
        if (binderContext.getHintValueContext().isSkipMetadataValidate() || null == schema) {
            return;
        }
        ShardingSphereTable shardingSphereTable = schema.getTable(tableName);
        if (binderContext.getSqlStatement() instanceof AlterTableStatement) {
            if (SimpleTableSegmentBinder.isRenameTable((AlterTableStatement)binderContext.getSqlStatement(), tableName)) {
                return;
            }
            ShardingSpherePreconditions.checkState((boolean)schema.containsTable(tableName), () -> new TableNotFoundException(tableName));
            AlterTableMetadataCheckUtils.checkAlterTable((AlterTableStatement)binderContext.getSqlStatement(), shardingSphereTable);
            return;
        }
        if (binderContext.getSqlStatement() instanceof CreateIndexStatement) {
            ShardingSpherePreconditions.checkState((boolean)schema.containsTable(tableName), () -> new TableNotFoundException(tableName));
            String indexName = ((CreateIndexStatement)binderContext.getSqlStatement()).getIndex().getIndexName().getIdentifier().getValue();
            ShardingSpherePreconditions.checkState((!shardingSphereTable.containsIndex(indexName) ? 1 : 0) != 0, () -> new DuplicateIndexException(indexName));
            return;
        }
        if (binderContext.getSqlStatement() instanceof DropIndexStatement) {
            ShardingSpherePreconditions.checkState((boolean)schema.containsTable(tableName), () -> new TableNotFoundException(tableName));
            ((DropIndexStatement)binderContext.getSqlStatement()).getIndexes().forEach(each -> {
                String indexName = each.getIndexName().getIdentifier().getValue();
                ShardingSpherePreconditions.checkState((boolean)shardingSphereTable.containsIndex(indexName), () -> new IndexNotFoundException(schemaName, indexName));
            });
        }
    }

    private static SimpleTableSegmentBinderContext createSimpleTableBinderContext(SimpleTableSegment segment, ShardingSphereSchema schema, IdentifierValue databaseName, IdentifierValue schemaName, SQLStatementBinderContext binderContext) {
        IdentifierValue tableName = segment.getTableName().getIdentifier();
        if (null != schema && schema.containsTable(tableName.getValue())) {
            return SimpleTableSegmentBinder.createSimpleTableSegmentBinderContextWithMetaData(segment, schema, databaseName, schemaName, binderContext, tableName);
        }
        if (binderContext.getSqlStatement() instanceof CreateTableStatement) {
            Collection<ProjectionSegment> projectionSegments = SimpleTableSegmentBinder.createProjectionSegments((CreateTableStatement)binderContext.getSqlStatement(), databaseName, schemaName, tableName);
            return new SimpleTableSegmentBinderContext(projectionSegments, TableSourceType.PHYSICAL_TABLE);
        }
        CaseInsensitiveMap.CaseInsensitiveString caseInsensitiveTableName = CaseInsensitiveMap.CaseInsensitiveString.of((String)tableName.getValue());
        if (binderContext.getExternalTableBinderContexts().containsKey((Object)caseInsensitiveTableName)) {
            TableSegmentBinderContext tableSegmentBinderContext = (TableSegmentBinderContext)binderContext.getExternalTableBinderContexts().get((Object)caseInsensitiveTableName).iterator().next();
            Collection<ProjectionSegment> subqueryProjections = SubqueryTableBindUtils.createSubqueryProjections(tableSegmentBinderContext.getProjectionSegments(), tableName, binderContext.getSqlStatement().getDatabaseType(), TableSourceType.TEMPORARY_TABLE);
            return new SimpleTableSegmentBinderContext(subqueryProjections, TableSourceType.TEMPORARY_TABLE);
        }
        return new SimpleTableSegmentBinderContext(Collections.emptyList(), TableSourceType.TEMPORARY_TABLE);
    }

    private static Collection<ProjectionSegment> createProjectionSegments(CreateTableStatement sqlStatement, IdentifierValue databaseName, IdentifierValue schemaName, IdentifierValue tableName) {
        LinkedList<ProjectionSegment> result = new LinkedList<ProjectionSegment>();
        for (ColumnDefinitionSegment each : sqlStatement.getColumnDefinitions()) {
            each.getColumnName().setColumnBoundInfo(new ColumnSegmentBoundInfo(new TableSegmentBoundInfo(databaseName, schemaName), tableName, each.getColumnName().getIdentifier(), TableSourceType.TEMPORARY_TABLE));
            result.add((ProjectionSegment)new ColumnProjectionSegment(each.getColumnName()));
        }
        return result;
    }

    private static SimpleTableSegmentBinderContext createSimpleTableSegmentBinderContextWithMetaData(SimpleTableSegment segment, ShardingSphereSchema schema, IdentifierValue databaseName, IdentifierValue schemaName, SQLStatementBinderContext binderContext, IdentifierValue tableName) {
        LinkedList<ProjectionSegment> projectionSegments = new LinkedList<ProjectionSegment>();
        QuoteCharacter quoteCharacter = new DatabaseTypeRegistry(binderContext.getSqlStatement().getDatabaseType()).getDialectDatabaseMetaData().getQuoteCharacter();
        for (ShardingSphereColumn each : schema.getTable(tableName.getValue()).getAllColumns()) {
            ColumnProjectionSegment columnProjectionSegment = new ColumnProjectionSegment(SimpleTableSegmentBinder.createColumnSegment(segment, databaseName, schemaName, each, quoteCharacter, tableName));
            columnProjectionSegment.setVisible(each.isVisible());
            projectionSegments.add((ProjectionSegment)columnProjectionSegment);
        }
        return new SimpleTableSegmentBinderContext(projectionSegments, TableSourceType.PHYSICAL_TABLE);
    }

    private static ColumnSegment createColumnSegment(SimpleTableSegment segment, IdentifierValue databaseName, IdentifierValue schemaName, ShardingSphereColumn column, QuoteCharacter quoteCharacter, IdentifierValue tableName) {
        ColumnSegment result = new ColumnSegment(0, 0, new IdentifierValue(column.getName(), quoteCharacter));
        result.setOwner(new OwnerSegment(0, 0, segment.getAlias().orElse(tableName)));
        result.setColumnBoundInfo(new ColumnSegmentBoundInfo(new TableSegmentBoundInfo(databaseName, schemaName), tableName, new IdentifierValue(column.getName(), quoteCharacter), TableSourceType.PHYSICAL_TABLE));
        return result;
    }

    @Generated
    private SimpleTableSegmentBinder() {
    }
}

