/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.binder.engine.segment.dml.from.type;

import com.cedarsoftware.util.CaseInsensitiveMap;
import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Multimap;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.apache.shardingsphere.database.connector.core.metadata.database.metadata.option.join.DialectJoinOption;
import org.apache.shardingsphere.database.connector.core.type.DatabaseType;
import org.apache.shardingsphere.database.connector.core.type.DatabaseTypeRegistry;
import org.apache.shardingsphere.infra.binder.engine.segment.SegmentType;
import org.apache.shardingsphere.infra.binder.engine.segment.dml.expression.ExpressionSegmentBinder;
import org.apache.shardingsphere.infra.binder.engine.segment.dml.expression.type.ColumnSegmentBinder;
import org.apache.shardingsphere.infra.binder.engine.segment.dml.from.TableSegmentBinder;
import org.apache.shardingsphere.infra.binder.engine.segment.dml.from.context.TableSegmentBinderContext;
import org.apache.shardingsphere.infra.binder.engine.statement.SQLStatementBinderContext;
import org.apache.shardingsphere.infra.exception.ShardingSpherePreconditions;
import org.apache.shardingsphere.sql.parser.statement.core.enums.JoinType;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.column.ColumnSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.item.ColumnProjectionSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.item.ProjectionSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.generic.table.JoinTableSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.generic.table.SimpleTableSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.generic.table.SubqueryTableSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.generic.table.TableSegment;

public final class JoinTableSegmentBinder {
    public static JoinTableSegment bind(JoinTableSegment segment, SQLStatementBinderContext binderContext, Multimap<CaseInsensitiveMap.CaseInsensitiveString, TableSegmentBinderContext> tableBinderContexts, Multimap<CaseInsensitiveMap.CaseInsensitiveString, TableSegmentBinderContext> outerTableBinderContexts) {
        Map<String, ProjectionSegment> usingColumnsByNaturalJoin;
        JoinTableSegment result = new JoinTableSegment();
        result.setStartIndex(segment.getStartIndex());
        result.setStopIndex(segment.getStopIndex());
        segment.getAliasSegment().ifPresent(arg_0 -> ((JoinTableSegment)result).setAlias(arg_0));
        result.setNatural(segment.isNatural());
        result.setJoinType(segment.getJoinType());
        result.setLeft(TableSegmentBinder.bind(segment.getLeft(), binderContext, tableBinderContexts, outerTableBinderContexts));
        result.setRight(TableSegmentBinder.bind(segment.getRight(), binderContext, tableBinderContexts, outerTableBinderContexts));
        result.setCondition(ExpressionSegmentBinder.bind(segment.getCondition(), SegmentType.JOIN_ON, binderContext, tableBinderContexts, outerTableBinderContexts));
        result.setUsing(JoinTableSegmentBinder.bindUsingColumns(segment.getUsing(), tableBinderContexts));
        result.getUsing().forEach(each -> binderContext.getUsingColumnNames().add(each.getIdentifier().getValue()));
        if (result.isNatural()) {
            usingColumnsByNaturalJoin = JoinTableSegmentBinder.getUsingColumnsByNaturalJoin(result, tableBinderContexts);
            Collection<ColumnSegment> derivedUsingColumns = JoinTableSegmentBinder.getDerivedUsingColumns(usingColumnsByNaturalJoin);
            result.setDerivedUsing(JoinTableSegmentBinder.bindUsingColumns(derivedUsingColumns, tableBinderContexts));
            result.getDerivedUsing().forEach(each -> binderContext.getUsingColumnNames().add(each.getIdentifier().getValue()));
        } else {
            usingColumnsByNaturalJoin = Collections.emptyMap();
        }
        result.getDerivedJoinTableProjectionSegments().addAll(JoinTableSegmentBinder.getDerivedJoinTableProjectionSegments(result, binderContext.getSqlStatement().getDatabaseType(), usingColumnsByNaturalJoin, tableBinderContexts));
        binderContext.getJoinTableProjectionSegments().addAll(result.getDerivedJoinTableProjectionSegments());
        return result;
    }

    private static Collection<ColumnSegment> getDerivedUsingColumns(Map<String, ProjectionSegment> usingColumnsByNaturalJoin) {
        LinkedList<ColumnSegment> result = new LinkedList<ColumnSegment>();
        for (ProjectionSegment each : usingColumnsByNaturalJoin.values()) {
            if (!(each instanceof ColumnProjectionSegment)) continue;
            ColumnSegment column = ((ColumnProjectionSegment)each).getColumn();
            result.add(new ColumnSegment(column.getStartIndex(), column.getStopIndex(), column.getIdentifier()));
        }
        return result;
    }

    private static List<ColumnSegment> bindUsingColumns(Collection<ColumnSegment> usingColumns, Multimap<CaseInsensitiveMap.CaseInsensitiveString, TableSegmentBinderContext> tableBinderContexts) {
        LinkedList<ColumnSegment> result = new LinkedList<ColumnSegment>();
        for (ColumnSegment each : usingColumns) {
            result.add(ColumnSegmentBinder.bindUsingColumn(each, SegmentType.JOIN_USING, tableBinderContexts));
        }
        return result;
    }

    private static Collection<ProjectionSegment> getDerivedJoinTableProjectionSegments(JoinTableSegment segment, DatabaseType databaseType, Map<String, ProjectionSegment> usingColumnsByNaturalJoin, Multimap<CaseInsensitiveMap.CaseInsensitiveString, TableSegmentBinderContext> tableBinderContexts) {
        DialectJoinOption joinOrderOption = new DatabaseTypeRegistry(databaseType).getDialectDatabaseMetaData().getJoinOption();
        Collection<ProjectionSegment> projectionSegments = JoinTableSegmentBinder.getProjectionSegments(segment, joinOrderOption, tableBinderContexts);
        if (segment.getUsing().isEmpty() && !segment.isNatural()) {
            return projectionSegments;
        }
        LinkedList<ProjectionSegment> result = new LinkedList<ProjectionSegment>();
        Map<String, ProjectionSegment> originalUsingColumns = segment.getUsing().isEmpty() ? usingColumnsByNaturalJoin : JoinTableSegmentBinder.getUsingColumns(projectionSegments, segment.getUsing(), segment.getJoinType());
        Collection<ProjectionSegment> orderedUsingColumns = joinOrderOption.isUsingColumnsByProjectionOrder() ? JoinTableSegmentBinder.getJoinUsingColumnsByProjectionOrder(projectionSegments, originalUsingColumns) : originalUsingColumns.values();
        result.addAll(orderedUsingColumns);
        result.addAll(JoinTableSegmentBinder.getJoinRemainingColumns(projectionSegments, originalUsingColumns));
        return result;
    }

    private static Collection<ProjectionSegment> getProjectionSegments(JoinTableSegment segment, DialectJoinOption joinOrderOption, Multimap<CaseInsensitiveMap.CaseInsensitiveString, TableSegmentBinderContext> tableBinderContexts) {
        LinkedList<ProjectionSegment> result = new LinkedList<ProjectionSegment>();
        if (joinOrderOption.isRightColumnsByFirstOrder() && JoinType.RIGHT.name().equalsIgnoreCase(segment.getJoinType()) && (!segment.getUsing().isEmpty() || segment.isNatural())) {
            result.addAll(JoinTableSegmentBinder.getProjectionSegments(segment.getRight(), tableBinderContexts));
            result.addAll(JoinTableSegmentBinder.getProjectionSegments(segment.getLeft(), tableBinderContexts));
        } else {
            result.addAll(JoinTableSegmentBinder.getProjectionSegments(segment.getLeft(), tableBinderContexts));
            result.addAll(JoinTableSegmentBinder.getProjectionSegments(segment.getRight(), tableBinderContexts));
        }
        return result;
    }

    private static Collection<ProjectionSegment> getProjectionSegments(TableSegment tableSegment, Multimap<CaseInsensitiveMap.CaseInsensitiveString, TableSegmentBinderContext> tableBinderContexts) {
        LinkedList<ProjectionSegment> result = new LinkedList<ProjectionSegment>();
        if (tableSegment instanceof SimpleTableSegment) {
            String tableAliasOrName = tableSegment.getAliasName().orElseGet(() -> ((SimpleTableSegment)tableSegment).getTableName().getIdentifier().getValue());
            result.addAll(JoinTableSegmentBinder.getProjectionSegmentsByTableAliasOrName(tableBinderContexts, tableAliasOrName));
        } else if (tableSegment instanceof JoinTableSegment) {
            result.addAll(((JoinTableSegment)tableSegment).getDerivedJoinTableProjectionSegments());
        } else if (tableSegment instanceof SubqueryTableSegment) {
            result.addAll(JoinTableSegmentBinder.getProjectionSegmentsByTableAliasOrName(tableBinderContexts, tableSegment.getAliasName().orElse("")));
        }
        return result;
    }

    private static Collection<ProjectionSegment> getProjectionSegmentsByTableAliasOrName(Multimap<CaseInsensitiveMap.CaseInsensitiveString, TableSegmentBinderContext> tableBinderContexts, String tableAliasOrName) {
        ShardingSpherePreconditions.checkNotNull((Object)tableAliasOrName, () -> new IllegalStateException("Table alias or name for shorthand projection segment owner can not be null."));
        ShardingSpherePreconditions.checkContains((Collection)tableBinderContexts.keySet(), (Object)CaseInsensitiveMap.CaseInsensitiveString.of((String)tableAliasOrName), () -> new IllegalStateException(String.format("Can not find table binder context by table alias or name %s.", tableAliasOrName)));
        return ((TableSegmentBinderContext)tableBinderContexts.get((Object)CaseInsensitiveMap.CaseInsensitiveString.of((String)tableAliasOrName)).iterator().next()).getProjectionSegments();
    }

    private static Map<String, ProjectionSegment> getUsingColumnsByNaturalJoin(JoinTableSegment segment, Multimap<CaseInsensitiveMap.CaseInsensitiveString, TableSegmentBinderContext> tableBinderContexts) {
        CaseInsensitiveMap result = new CaseInsensitiveMap();
        Collection<ProjectionSegment> leftProjections = JoinTableSegmentBinder.getProjectionSegments(segment.getLeft(), tableBinderContexts);
        CaseInsensitiveMap rightProjections = new CaseInsensitiveMap();
        JoinTableSegmentBinder.getProjectionSegments(segment.getRight(), tableBinderContexts).forEach(arg_0 -> JoinTableSegmentBinder.lambda$getUsingColumnsByNaturalJoin$5((Map)rightProjections, arg_0));
        for (ProjectionSegment each : leftProjections) {
            String columnLabel = each.getColumnLabel();
            if (!rightProjections.containsKey(columnLabel)) continue;
            result.put(columnLabel, each);
        }
        return result;
    }

    private static Map<String, ProjectionSegment> getUsingColumns(Collection<ProjectionSegment> projectionSegments, Collection<ColumnSegment> usingColumns, String joinType) {
        LinkedHashMultimap columnLabelProjectionSegments = LinkedHashMultimap.create();
        for (ProjectionSegment projectionSegment : projectionSegments) {
            if (null == projectionSegment.getColumnLabel()) continue;
            columnLabelProjectionSegments.put((Object)CaseInsensitiveMap.CaseInsensitiveString.of((String)projectionSegment.getColumnLabel()), (Object)projectionSegment);
        }
        CaseInsensitiveMap result = new CaseInsensitiveMap();
        for (ColumnSegment each : usingColumns) {
            LinkedList groupProjectionSegments = new LinkedList(columnLabelProjectionSegments.get((Object)CaseInsensitiveMap.CaseInsensitiveString.of((String)each.getIdentifier().getValue())));
            if (groupProjectionSegments.isEmpty()) continue;
            ProjectionSegment targetProjectionSegment = JoinType.RIGHT.name().equalsIgnoreCase(joinType) ? (ProjectionSegment)groupProjectionSegments.descendingIterator().next() : (ProjectionSegment)groupProjectionSegments.iterator().next();
            result.put(targetProjectionSegment.getColumnLabel(), targetProjectionSegment);
        }
        return result;
    }

    private static Collection<ProjectionSegment> getJoinUsingColumnsByProjectionOrder(Collection<ProjectionSegment> projectionSegments, Map<String, ProjectionSegment> usingColumns) {
        CaseInsensitiveMap result = new CaseInsensitiveMap(usingColumns.size(), 1.0f);
        for (ProjectionSegment each : projectionSegments) {
            String columnLabel = each.getColumnLabel();
            if (result.containsKey(columnLabel) || !usingColumns.containsKey(columnLabel)) continue;
            result.put(columnLabel, each);
        }
        return result.values();
    }

    private static Collection<ProjectionSegment> getJoinRemainingColumns(Collection<ProjectionSegment> projectionSegments, Map<String, ProjectionSegment> usingColumns) {
        LinkedList<ProjectionSegment> result = new LinkedList<ProjectionSegment>();
        for (ProjectionSegment each : projectionSegments) {
            if (usingColumns.containsKey(each.getColumnLabel())) continue;
            result.add(each);
        }
        return result;
    }

    @Generated
    private JoinTableSegmentBinder() {
    }

    private static /* synthetic */ void lambda$getUsingColumnsByNaturalJoin$5(Map rightProjections, ProjectionSegment each) {
        rightProjections.put(each.getColumnLabel(), each);
    }
}

