/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.binder.engine.segment.dml.from;

import com.cedarsoftware.util.CaseInsensitiveMap;
import com.google.common.collect.Multimap;
import lombok.Generated;
import org.apache.shardingsphere.infra.binder.engine.segment.dml.from.context.TableSegmentBinderContext;
import org.apache.shardingsphere.infra.binder.engine.segment.dml.from.context.type.FunctionTableSegmentBinderContext;
import org.apache.shardingsphere.infra.binder.engine.segment.dml.from.type.DeleteMultiTableSegmentBinder;
import org.apache.shardingsphere.infra.binder.engine.segment.dml.from.type.JoinTableSegmentBinder;
import org.apache.shardingsphere.infra.binder.engine.segment.dml.from.type.SimpleTableSegmentBinder;
import org.apache.shardingsphere.infra.binder.engine.segment.dml.from.type.SubqueryTableSegmentBinder;
import org.apache.shardingsphere.infra.binder.engine.statement.SQLStatementBinderContext;
import org.apache.shardingsphere.sql.parser.statement.core.segment.generic.table.CollectionTableSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.generic.table.DeleteMultiTableSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.generic.table.FunctionTableSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.generic.table.JoinTableSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.generic.table.SimpleTableSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.generic.table.SubqueryTableSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.generic.table.TableSegment;

public final class TableSegmentBinder {
    public static TableSegment bind(TableSegment segment, SQLStatementBinderContext binderContext, Multimap<CaseInsensitiveMap.CaseInsensitiveString, TableSegmentBinderContext> tableBinderContexts, Multimap<CaseInsensitiveMap.CaseInsensitiveString, TableSegmentBinderContext> outerTableBinderContexts) {
        if (segment instanceof SimpleTableSegment) {
            return SimpleTableSegmentBinder.bind((SimpleTableSegment)segment, binderContext, tableBinderContexts);
        }
        if (segment instanceof JoinTableSegment) {
            return JoinTableSegmentBinder.bind((JoinTableSegment)segment, binderContext, tableBinderContexts, outerTableBinderContexts);
        }
        if (segment instanceof SubqueryTableSegment) {
            return SubqueryTableSegmentBinder.bind((SubqueryTableSegment)segment, binderContext, tableBinderContexts, outerTableBinderContexts, false);
        }
        if (segment instanceof DeleteMultiTableSegment) {
            return DeleteMultiTableSegmentBinder.bind((DeleteMultiTableSegment)segment, binderContext, tableBinderContexts);
        }
        if (segment instanceof FunctionTableSegment) {
            String name = segment.getAliasName().orElseGet(() -> ((FunctionTableSegment)segment).getTableFunction().getText());
            if (null != name) {
                tableBinderContexts.put((Object)CaseInsensitiveMap.CaseInsensitiveString.of((String)name), (Object)new FunctionTableSegmentBinderContext());
            }
            return segment;
        }
        if (segment instanceof CollectionTableSegment) {
            String name = segment.getAliasName().orElseGet(() -> ((CollectionTableSegment)segment).getExpressionSegment().getText());
            if (null != name) {
                tableBinderContexts.put((Object)CaseInsensitiveMap.CaseInsensitiveString.of((String)name), (Object)new FunctionTableSegmentBinderContext());
            }
            return segment;
        }
        return segment;
    }

    @Generated
    private TableSegmentBinder() {
    }
}

