/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.binder.engine.segment.dml.expression.type;

import com.cedarsoftware.util.CaseInsensitiveMap;
import com.google.common.collect.Multimap;
import java.util.Map;
import lombok.Generated;
import org.apache.shardingsphere.infra.binder.engine.segment.SegmentType;
import org.apache.shardingsphere.infra.binder.engine.segment.dml.expression.ExpressionSegmentBinder;
import org.apache.shardingsphere.infra.binder.engine.segment.dml.from.context.TableSegmentBinderContext;
import org.apache.shardingsphere.infra.binder.engine.statement.SQLStatementBinderContext;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.expr.ExpressionSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.expr.FunctionSegment;

public final class FunctionExpressionSegmentBinder {
    private static final Map<String, Integer> SKIP_BIND_FUNCTION_PARAMETER_INDEXES = new CaseInsensitiveMap();

    public static FunctionSegment bind(FunctionSegment segment, SegmentType parentSegmentType, SQLStatementBinderContext binderContext, Multimap<CaseInsensitiveMap.CaseInsensitiveString, TableSegmentBinderContext> tableBinderContexts, Multimap<CaseInsensitiveMap.CaseInsensitiveString, TableSegmentBinderContext> outerTableBinderContexts) {
        FunctionSegment result = new FunctionSegment(segment.getStartIndex(), segment.getStopIndex(), segment.getFunctionName(), segment.getText());
        result.setOwner(segment.getOwner());
        int index = 0;
        Integer skipParameterIndex = SKIP_BIND_FUNCTION_PARAMETER_INDEXES.getOrDefault(segment.getFunctionName(), -1);
        for (ExpressionSegment each : segment.getParameters()) {
            if (skipParameterIndex >= 0 && index++ == skipParameterIndex) {
                result.getParameters().add(each);
                continue;
            }
            result.getParameters().add(ExpressionSegmentBinder.bind(each, parentSegmentType, binderContext, tableBinderContexts, outerTableBinderContexts));
        }
        segment.getWindow().ifPresent(arg_0 -> ((FunctionSegment)result).setWindow(arg_0));
        return result;
    }

    @Generated
    private FunctionExpressionSegmentBinder() {
    }

    static {
        SKIP_BIND_FUNCTION_PARAMETER_INDEXES.put("XMLELEMENT", 0);
    }
}

