/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.binder.engine;

import java.util.Optional;
import lombok.Generated;
import org.apache.shardingsphere.database.connector.core.spi.DatabaseTypedSPILoader;
import org.apache.shardingsphere.database.connector.core.type.DatabaseType;
import org.apache.shardingsphere.infra.binder.context.SQLStatementContextFactory;
import org.apache.shardingsphere.infra.binder.context.statement.SQLStatementContext;
import org.apache.shardingsphere.infra.binder.engine.DialectSQLBindEngine;
import org.apache.shardingsphere.infra.binder.engine.statement.SQLStatementBinderContext;
import org.apache.shardingsphere.infra.binder.engine.type.DALStatementBindEngine;
import org.apache.shardingsphere.infra.binder.engine.type.DCLStatementBindEngine;
import org.apache.shardingsphere.infra.binder.engine.type.DDLStatementBindEngine;
import org.apache.shardingsphere.infra.binder.engine.type.DMLStatementBindEngine;
import org.apache.shardingsphere.infra.hint.HintManager;
import org.apache.shardingsphere.infra.hint.HintValueContext;
import org.apache.shardingsphere.infra.metadata.ShardingSphereMetaData;
import org.apache.shardingsphere.sql.parser.statement.core.statement.SQLStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.type.dal.DALStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.type.dcl.DCLStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.type.ddl.DDLStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.type.dml.DMLStatement;

public final class SQLBindEngine {
    private final ShardingSphereMetaData metaData;
    private final String currentDatabaseName;
    private final HintValueContext hintValueContext;

    public SQLStatementContext bind(SQLStatement sqlStatement) {
        SQLStatement boundSQLStatement = this.isNeedBind() ? this.bindSQLStatement(sqlStatement) : sqlStatement;
        return SQLStatementContextFactory.newInstance(this.metaData, boundSQLStatement, this.currentDatabaseName);
    }

    private SQLStatement bindSQLStatement(SQLStatement sqlStatement) {
        Optional<SQLStatement> boundSQLStatement;
        SQLStatementBinderContext binderContext = new SQLStatementBinderContext(this.metaData, this.currentDatabaseName, this.hintValueContext, sqlStatement);
        Optional dialectSQLBindEngine = DatabaseTypedSPILoader.findService(DialectSQLBindEngine.class, (DatabaseType)sqlStatement.getDatabaseType());
        if (dialectSQLBindEngine.isPresent() && (boundSQLStatement = ((DialectSQLBindEngine)dialectSQLBindEngine.get()).bind(sqlStatement, binderContext)).isPresent()) {
            return boundSQLStatement.get();
        }
        if (sqlStatement instanceof DMLStatement) {
            return new DMLStatementBindEngine().bind((DMLStatement)sqlStatement, binderContext);
        }
        if (sqlStatement instanceof DDLStatement) {
            return new DDLStatementBindEngine().bind((DDLStatement)sqlStatement, binderContext);
        }
        if (sqlStatement instanceof DCLStatement) {
            return new DCLStatementBindEngine().bind((DCLStatement)sqlStatement, binderContext);
        }
        if (sqlStatement instanceof DALStatement) {
            return new DALStatementBindEngine().bind((DALStatement)sqlStatement, binderContext);
        }
        return sqlStatement;
    }

    private boolean isNeedBind() {
        return !this.hintValueContext.findHintDataSourceName().isPresent() && !HintManager.getDataSourceName().isPresent();
    }

    @Generated
    public SQLBindEngine(ShardingSphereMetaData metaData, String currentDatabaseName, HintValueContext hintValueContext) {
        this.metaData = metaData;
        this.currentDatabaseName = currentDatabaseName;
        this.hintValueContext = hintValueContext;
    }
}

