/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.binder.context.statement.type.dml;

import java.util.Collection;
import java.util.LinkedList;
import lombok.Generated;
import org.apache.shardingsphere.infra.binder.context.segment.table.TablesContext;
import org.apache.shardingsphere.infra.binder.context.statement.SQLStatementContext;
import org.apache.shardingsphere.sql.parser.statement.core.extractor.ColumnExtractor;
import org.apache.shardingsphere.sql.parser.statement.core.extractor.ExpressionExtractor;
import org.apache.shardingsphere.sql.parser.statement.core.extractor.TableExtractor;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.column.ColumnSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.expr.BinaryOperationExpression;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.predicate.WhereSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.generic.table.SimpleTableSegment;
import org.apache.shardingsphere.sql.parser.statement.core.statement.type.dml.UpdateStatement;

public final class UpdateStatementBaseContext
implements SQLStatementContext {
    private final UpdateStatement sqlStatement;
    private final TablesContext tablesContext;
    private final Collection<WhereSegment> whereSegments;
    private final Collection<ColumnSegment> columnSegments;
    private final Collection<BinaryOperationExpression> joinConditions = new LinkedList<BinaryOperationExpression>();

    public UpdateStatementBaseContext(UpdateStatement sqlStatement) {
        this.sqlStatement = sqlStatement;
        this.tablesContext = new TablesContext(this.getAllSimpleTableSegments());
        this.whereSegments = this.createWhereSegments(sqlStatement);
        this.columnSegments = ColumnExtractor.extractColumnSegments(this.whereSegments);
        ExpressionExtractor.extractJoinConditions(this.joinConditions, this.whereSegments);
    }

    private Collection<WhereSegment> createWhereSegments(UpdateStatement updateStatement) {
        LinkedList<WhereSegment> result = new LinkedList<WhereSegment>();
        updateStatement.getWhere().ifPresent(result::add);
        return result;
    }

    private Collection<SimpleTableSegment> getAllSimpleTableSegments() {
        TableExtractor tableExtractor = new TableExtractor();
        tableExtractor.extractTablesFromUpdate(this.sqlStatement);
        return tableExtractor.getRewriteTables();
    }

    @Generated
    public UpdateStatement getSqlStatement() {
        return this.sqlStatement;
    }

    @Override
    @Generated
    public TablesContext getTablesContext() {
        return this.tablesContext;
    }

    @Generated
    public Collection<WhereSegment> getWhereSegments() {
        return this.whereSegments;
    }

    @Generated
    public Collection<ColumnSegment> getColumnSegments() {
        return this.columnSegments;
    }

    @Generated
    public Collection<BinaryOperationExpression> getJoinConditions() {
        return this.joinConditions;
    }
}

