/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.binder.context.statement.type.dml;

import com.google.common.base.Preconditions;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import lombok.Generated;
import org.apache.shardingsphere.database.exception.core.exception.syntax.database.NoDatabaseSelectedException;
import org.apache.shardingsphere.database.exception.core.exception.syntax.database.UnknownDatabaseException;
import org.apache.shardingsphere.infra.binder.context.segment.select.groupby.GroupByContext;
import org.apache.shardingsphere.infra.binder.context.segment.select.groupby.engine.GroupByContextEngine;
import org.apache.shardingsphere.infra.binder.context.segment.select.orderby.OrderByContext;
import org.apache.shardingsphere.infra.binder.context.segment.select.orderby.OrderByItem;
import org.apache.shardingsphere.infra.binder.context.segment.select.orderby.engine.OrderByContextEngine;
import org.apache.shardingsphere.infra.binder.context.segment.select.projection.Projection;
import org.apache.shardingsphere.infra.binder.context.segment.select.projection.ProjectionsContext;
import org.apache.shardingsphere.infra.binder.context.segment.select.projection.engine.ProjectionsContextEngine;
import org.apache.shardingsphere.infra.binder.context.segment.select.projection.impl.AggregationDistinctProjection;
import org.apache.shardingsphere.infra.binder.context.segment.select.projection.impl.AggregationProjection;
import org.apache.shardingsphere.infra.binder.context.segment.select.projection.impl.ColumnProjection;
import org.apache.shardingsphere.infra.binder.context.segment.select.projection.impl.ParameterMarkerProjection;
import org.apache.shardingsphere.infra.binder.context.segment.select.projection.impl.SubqueryProjection;
import org.apache.shardingsphere.infra.binder.context.segment.table.TablesContext;
import org.apache.shardingsphere.infra.binder.context.statement.SQLStatementContext;
import org.apache.shardingsphere.infra.binder.context.statement.type.dml.SelectStatementContext;
import org.apache.shardingsphere.infra.exception.ShardingSpherePreconditions;
import org.apache.shardingsphere.infra.metadata.ShardingSphereMetaData;
import org.apache.shardingsphere.infra.metadata.database.ShardingSphereDatabase;
import org.apache.shardingsphere.infra.rule.attribute.table.TableMapperRuleAttribute;
import org.apache.shardingsphere.sql.parser.statement.core.enums.ParameterMarkerType;
import org.apache.shardingsphere.sql.parser.statement.core.enums.SubqueryType;
import org.apache.shardingsphere.sql.parser.statement.core.extractor.ColumnExtractor;
import org.apache.shardingsphere.sql.parser.statement.core.extractor.ExpressionExtractor;
import org.apache.shardingsphere.sql.parser.statement.core.extractor.SubqueryExtractor;
import org.apache.shardingsphere.sql.parser.statement.core.extractor.TableExtractor;
import org.apache.shardingsphere.sql.parser.statement.core.extractor.WhereExtractor;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.column.ColumnSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.expr.BinaryOperationExpression;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.expr.ExpressionSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.expr.simple.ParameterMarkerExpressionSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.expr.subquery.SubquerySegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.order.item.ColumnOrderByItemSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.order.item.ExpressionOrderByItemSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.order.item.IndexOrderByItemSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.order.item.OrderByItemSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.order.item.TextOrderByItemSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.predicate.WhereSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.generic.bound.ColumnSegmentBoundInfo;
import org.apache.shardingsphere.sql.parser.statement.core.segment.generic.table.JoinTableSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.generic.table.SimpleTableSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.generic.table.SubqueryTableSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.generic.table.TableSegment;
import org.apache.shardingsphere.sql.parser.statement.core.statement.type.dml.SelectStatement;
import org.apache.shardingsphere.sql.parser.statement.core.util.SQLUtils;
import org.apache.shardingsphere.sql.parser.statement.core.value.identifier.IdentifierValue;

public final class SelectStatementBaseContext
implements SQLStatementContext {
    private final SelectStatement sqlStatement;
    private final TablesContext tablesContext;
    private final ProjectionsContext projectionsContext;
    private final GroupByContext groupByContext;
    private final OrderByContext orderByContext;
    private final Map<Integer, SelectStatementContext> subqueryContexts;
    private final Collection<WhereSegment> whereSegments;
    private final Collection<ColumnSegment> columnSegments;
    private final Collection<BinaryOperationExpression> joinConditions = new LinkedList<BinaryOperationExpression>();
    private final boolean containsEnhancedTable;
    private SubqueryType subqueryType;
    private boolean needAggregateRewrite;

    public SelectStatementBaseContext(SelectStatement sqlStatement, ShardingSphereMetaData metaData, String currentDatabaseName, Collection<TableSegment> inheritedTables) {
        this.sqlStatement = sqlStatement;
        this.whereSegments = this.createWhereSegments(sqlStatement);
        this.columnSegments = ColumnExtractor.extractColumnSegments(this.whereSegments);
        Collection<TableSegment> tableSegments = this.getAllTableSegments(inheritedTables);
        ExpressionExtractor.extractJoinConditions(this.joinConditions, this.whereSegments);
        this.subqueryContexts = this.createSubqueryContexts(metaData, currentDatabaseName, tableSegments);
        this.tablesContext = new TablesContext(tableSegments);
        this.groupByContext = new GroupByContextEngine().createGroupByContext(sqlStatement);
        this.orderByContext = new OrderByContextEngine(sqlStatement.getDatabaseType()).createOrderBy(sqlStatement, this.groupByContext);
        this.projectionsContext = new ProjectionsContextEngine(sqlStatement.getDatabaseType()).createProjectionsContext(sqlStatement.getProjections(), this.groupByContext, this.orderByContext);
        this.containsEnhancedTable = this.isContainsEnhancedTable(metaData, this.tablesContext.getDatabaseNames(), currentDatabaseName);
    }

    private Collection<WhereSegment> createWhereSegments(SelectStatement selectStatement) {
        LinkedList<WhereSegment> result = new LinkedList<WhereSegment>();
        selectStatement.getWhere().ifPresent(result::add);
        result.addAll(WhereExtractor.extractSubqueryWhereSegments((SelectStatement)selectStatement));
        result.addAll(WhereExtractor.extractJoinWhereSegments((SelectStatement)selectStatement));
        return result;
    }

    private Collection<TableSegment> getAllTableSegments(Collection<TableSegment> inheritedTables) {
        TableExtractor tableExtractor = new TableExtractor();
        this.appendInheritedSimpleTables(inheritedTables, tableExtractor);
        tableExtractor.extractTablesFromSelect(this.sqlStatement);
        LinkedList<TableSegment> result = new LinkedList<TableSegment>(tableExtractor.getRewriteTables());
        for (TableSegment each : tableExtractor.getTableContext()) {
            if (!(each instanceof SubqueryTableSegment)) continue;
            result.add(each);
        }
        return result;
    }

    private void appendInheritedSimpleTables(Collection<TableSegment> inheritedTables, TableExtractor tableExtractor) {
        for (TableSegment each : inheritedTables) {
            if (!(each instanceof SimpleTableSegment)) continue;
            tableExtractor.getTableContext().add(each);
        }
    }

    private boolean isContainsEnhancedTable(ShardingSphereMetaData metaData, Collection<String> databaseNames, String currentDatabaseName) {
        for (String each : databaseNames) {
            if (!this.isContainsEnhancedTable(metaData, each, this.getTablesContext().getTableNames())) continue;
            return true;
        }
        return null != currentDatabaseName && this.isContainsEnhancedTable(metaData, currentDatabaseName, this.getTablesContext().getTableNames());
    }

    private boolean isContainsEnhancedTable(ShardingSphereMetaData metaData, String databaseName, Collection<String> tableNames) {
        for (TableMapperRuleAttribute each : this.getTableMapperRuleAttributes(metaData, databaseName)) {
            for (String tableName : tableNames) {
                if (!each.getEnhancedTableNames().contains(tableName)) continue;
                return true;
            }
        }
        return false;
    }

    private Collection<TableMapperRuleAttribute> getTableMapperRuleAttributes(ShardingSphereMetaData metaData, String databaseName) {
        if (null == databaseName) {
            ShardingSpherePreconditions.checkMustEmpty(this.tablesContext.getSimpleTables(), NoDatabaseSelectedException::new);
            return Collections.emptyList();
        }
        ShardingSphereDatabase database = metaData.getDatabase(databaseName);
        ShardingSpherePreconditions.checkNotNull((Object)database, () -> new UnknownDatabaseException(databaseName));
        return database.getRuleMetaData().getAttributes(TableMapperRuleAttribute.class);
    }

    private Map<Integer, SelectStatementContext> createSubqueryContexts(ShardingSphereMetaData metaData, String currentDatabaseName, Collection<TableSegment> tableSegments) {
        Collection subquerySegments = SubqueryExtractor.extractSubquerySegments((SelectStatement)this.sqlStatement, (boolean)false);
        HashMap<Integer, SelectStatementContext> result = new HashMap<Integer, SelectStatementContext>(subquerySegments.size(), 1.0f);
        for (SubquerySegment each : subquerySegments) {
            SelectStatementContext subqueryContext = new SelectStatementContext(each.getSelect(), metaData, currentDatabaseName, tableSegments);
            each.getSelect().getSubqueryType().ifPresent(subqueryContext::setSubqueryType);
            result.put(each.getStartIndex(), subqueryContext);
        }
        return result;
    }

    public boolean isContainsJoinQuery() {
        return this.sqlStatement.getFrom().isPresent() && this.sqlStatement.getFrom().get() instanceof JoinTableSegment;
    }

    public boolean isContainsSubquery() {
        return !this.subqueryContexts.isEmpty();
    }

    public boolean isContainsHaving() {
        return this.sqlStatement.getHaving().isPresent();
    }

    public boolean isContainsCombine() {
        return this.sqlStatement.getCombine().isPresent();
    }

    public boolean isContainsDollarParameterMarker() {
        for (Projection projection : this.projectionsContext.getProjections()) {
            if (!(projection instanceof ParameterMarkerProjection) || ParameterMarkerType.DOLLAR != ((ParameterMarkerProjection)projection).getParameterMarkerType()) continue;
            return true;
        }
        for (ParameterMarkerExpressionSegment parameterMarkerExpressionSegment : this.getParameterMarkerExpressions()) {
            if (ParameterMarkerType.DOLLAR != parameterMarkerExpressionSegment.getParameterMarkerType()) continue;
            return true;
        }
        return false;
    }

    private Collection<ParameterMarkerExpressionSegment> getParameterMarkerExpressions() {
        LinkedList<ExpressionSegment> expressions = new LinkedList<ExpressionSegment>();
        for (WhereSegment each : this.whereSegments) {
            expressions.add(each.getExpr());
        }
        return ExpressionExtractor.getParameterMarkerExpressions(expressions);
    }

    public boolean isContainsPartialDistinctAggregation() {
        Collection<Projection> aggregationProjections = this.getAggregationProjections(this.projectionsContext.getProjections());
        Collection<AggregationDistinctProjection> aggregationDistinctProjections = this.projectionsContext.getAggregationDistinctProjections();
        return aggregationProjections.size() > 1 && !aggregationDistinctProjections.isEmpty() && aggregationProjections.size() != aggregationDistinctProjections.size();
    }

    private Collection<Projection> getAggregationProjections(Collection<Projection> projections) {
        LinkedList<Projection> result = new LinkedList<Projection>();
        for (Projection each : projections) {
            if (!(each instanceof AggregationProjection)) continue;
            result.add(each);
        }
        return result;
    }

    public void setIndexes(Map<String, Integer> columnLabelIndexMap) {
        this.setIndexForAggregationProjection(columnLabelIndexMap);
        this.setIndexForOrderItem(columnLabelIndexMap, this.orderByContext.getItems());
        this.setIndexForOrderItem(columnLabelIndexMap, this.groupByContext.getItems());
    }

    private void setIndexForAggregationProjection(Map<String, Integer> columnLabelIndexMap) {
        for (AggregationProjection each : this.projectionsContext.getAggregationProjections()) {
            String columnLabel = SQLUtils.getExactlyValue((String)each.getAlias().map(IdentifierValue::getValue).orElse(each.getColumnName()));
            Preconditions.checkState((boolean)columnLabelIndexMap.containsKey(columnLabel), (String)"Can't find index: %s, please add alias for aggregate selections", (Object)each);
            each.setIndex(columnLabelIndexMap.get(columnLabel));
            for (AggregationProjection derived : each.getDerivedAggregationProjections()) {
                String derivedColumnLabel = SQLUtils.getExactlyValue((String)derived.getAlias().map(IdentifierValue::getValue).orElse(each.getColumnName()));
                Preconditions.checkState((boolean)columnLabelIndexMap.containsKey(derivedColumnLabel), (String)"Can't find index: %s", (Object)derived);
                derived.setIndex(columnLabelIndexMap.get(derivedColumnLabel));
            }
        }
    }

    private void setIndexForOrderItem(Map<String, Integer> columnLabelIndexMap, Collection<OrderByItem> orderByItems) {
        for (OrderByItem each : orderByItems) {
            Optional<Integer> itemIndex;
            if (each.getSegment() instanceof IndexOrderByItemSegment) {
                each.setIndex(((IndexOrderByItemSegment)each.getSegment()).getColumnIndex());
                continue;
            }
            if (each.getSegment() instanceof ColumnOrderByItemSegment && ((ColumnOrderByItemSegment)each.getSegment()).getColumn().getOwner().isPresent() && (itemIndex = this.projectionsContext.findProjectionIndex(((ColumnOrderByItemSegment)each.getSegment()).getText())).isPresent()) {
                each.setIndex(itemIndex.get());
                continue;
            }
            String columnLabel = this.getAlias(each.getSegment()).orElseGet(() -> this.getOrderItemText((TextOrderByItemSegment)each.getSegment()));
            Preconditions.checkState((boolean)columnLabelIndexMap.containsKey(columnLabel), (String)"Can't find index: %s", (Object)each);
            if (!columnLabelIndexMap.containsKey(columnLabel)) continue;
            each.setIndex(columnLabelIndexMap.get(columnLabel));
        }
    }

    private Optional<String> getAlias(OrderByItemSegment orderByItem) {
        if (this.projectionsContext.isUnqualifiedShorthandProjection()) {
            return Optional.empty();
        }
        String rawName = SQLUtils.getExactlyValue((String)((TextOrderByItemSegment)orderByItem).getText());
        for (Projection each : this.projectionsContext.getProjections()) {
            Optional<String> result = each.getAlias().map(IdentifierValue::getValue);
            if (SQLUtils.getExactlyExpression((String)rawName).equalsIgnoreCase(SQLUtils.getExactlyExpression((String)SQLUtils.getExactlyValue((String)each.getExpression())))) {
                return result;
            }
            if (rawName.equalsIgnoreCase(result.orElse(null))) {
                return Optional.of(rawName);
            }
            if (!this.isSameColumnName(each, rawName)) continue;
            return result;
        }
        return Optional.empty();
    }

    private boolean isSameColumnName(Projection projection, String name) {
        return projection instanceof ColumnProjection && name.equalsIgnoreCase(((ColumnProjection)projection).getName().getValue());
    }

    private String getOrderItemText(TextOrderByItemSegment orderByItemSegment) {
        if (orderByItemSegment instanceof ColumnOrderByItemSegment) {
            return SQLUtils.getExactlyValue((String)((ColumnOrderByItemSegment)orderByItemSegment).getColumn().getIdentifier().getValue());
        }
        return SQLUtils.getExactlyValue((String)((ExpressionOrderByItemSegment)orderByItemSegment).getExpression());
    }

    public boolean isSameGroupByAndOrderByItems() {
        return !this.groupByContext.getItems().isEmpty() && this.groupByContext.getItems().equals(this.orderByContext.getItems());
    }

    public Optional<ColumnSegmentBoundInfo> findColumnBoundInfo(int columnIndex) {
        List<Projection> expandProjections = this.projectionsContext.getExpandProjections();
        if (expandProjections.size() < columnIndex) {
            return Optional.empty();
        }
        Projection projection = expandProjections.get(columnIndex - 1);
        if (projection instanceof ColumnProjection) {
            return Optional.of(((ColumnProjection)projection).getColumnBoundInfo());
        }
        if (projection instanceof SubqueryProjection && ((SubqueryProjection)projection).getProjection() instanceof ColumnProjection) {
            return Optional.of(((ColumnProjection)((SubqueryProjection)projection).getProjection()).getColumnBoundInfo());
        }
        return Optional.empty();
    }

    public boolean containsTableSubquery() {
        return this.sqlStatement.getFrom().isPresent() && this.sqlStatement.getFrom().get() instanceof SubqueryTableSegment || this.sqlStatement.getWith().isPresent();
    }

    public boolean containsDerivedProjections() {
        return this.containsEnhancedTable && !this.projectionsContext.getExpandProjections().isEmpty();
    }

    @Generated
    public SelectStatement getSqlStatement() {
        return this.sqlStatement;
    }

    @Override
    @Generated
    public TablesContext getTablesContext() {
        return this.tablesContext;
    }

    @Generated
    public ProjectionsContext getProjectionsContext() {
        return this.projectionsContext;
    }

    @Generated
    public GroupByContext getGroupByContext() {
        return this.groupByContext;
    }

    @Generated
    public OrderByContext getOrderByContext() {
        return this.orderByContext;
    }

    @Generated
    public Map<Integer, SelectStatementContext> getSubqueryContexts() {
        return this.subqueryContexts;
    }

    @Generated
    public Collection<WhereSegment> getWhereSegments() {
        return this.whereSegments;
    }

    @Generated
    public Collection<ColumnSegment> getColumnSegments() {
        return this.columnSegments;
    }

    @Generated
    public Collection<BinaryOperationExpression> getJoinConditions() {
        return this.joinConditions;
    }

    @Generated
    public boolean isContainsEnhancedTable() {
        return this.containsEnhancedTable;
    }

    @Generated
    public SubqueryType getSubqueryType() {
        return this.subqueryType;
    }

    @Generated
    public boolean isNeedAggregateRewrite() {
        return this.needAggregateRewrite;
    }

    @Generated
    public void setSubqueryType(SubqueryType subqueryType) {
        this.subqueryType = subqueryType;
    }

    @Generated
    public void setNeedAggregateRewrite(boolean needAggregateRewrite) {
        this.needAggregateRewrite = needAggregateRewrite;
    }
}

