/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.binder.context.statement.type.ddl;

import java.util.Collection;
import java.util.Collections;
import lombok.Generated;
import org.apache.shardingsphere.infra.binder.context.available.WhereContextAvailable;
import org.apache.shardingsphere.infra.binder.context.segment.table.TablesContext;
import org.apache.shardingsphere.infra.binder.context.statement.SQLStatementContext;
import org.apache.shardingsphere.infra.binder.context.statement.type.dml.SelectStatementContext;
import org.apache.shardingsphere.infra.metadata.ShardingSphereMetaData;
import org.apache.shardingsphere.sql.parser.statement.core.enums.SubqueryType;
import org.apache.shardingsphere.sql.parser.statement.core.extractor.TableExtractor;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.column.ColumnSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.expr.BinaryOperationExpression;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.predicate.WhereSegment;
import org.apache.shardingsphere.sql.parser.statement.core.statement.type.ddl.view.CreateViewStatement;

public final class CreateViewStatementContext
implements SQLStatementContext,
WhereContextAvailable {
    private final CreateViewStatement sqlStatement;
    private final TablesContext tablesContext;
    private final SelectStatementContext selectStatementContext;

    public CreateViewStatementContext(ShardingSphereMetaData metaData, CreateViewStatement sqlStatement, String currentDatabaseName) {
        this.sqlStatement = sqlStatement;
        TableExtractor extractor = new TableExtractor();
        extractor.extractTablesFromCreateViewStatement(sqlStatement);
        this.tablesContext = new TablesContext(extractor.getRewriteTables());
        this.selectStatementContext = new SelectStatementContext(sqlStatement.getSelect(), metaData, currentDatabaseName, Collections.emptyList());
        this.selectStatementContext.setSubqueryType(SubqueryType.VIEW_DEFINITION);
    }

    @Override
    public Collection<WhereSegment> getWhereSegments() {
        return this.selectStatementContext.getWhereSegments();
    }

    @Override
    public Collection<ColumnSegment> getColumnSegments() {
        return this.selectStatementContext.getColumnSegments();
    }

    @Override
    public Collection<BinaryOperationExpression> getJoinConditions() {
        return this.selectStatementContext.getJoinConditions();
    }

    @Generated
    public CreateViewStatement getSqlStatement() {
        return this.sqlStatement;
    }

    @Override
    @Generated
    public TablesContext getTablesContext() {
        return this.tablesContext;
    }

    @Generated
    public SelectStatementContext getSelectStatementContext() {
        return this.selectStatementContext;
    }
}

