/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.binder.context.statement.type.ddl;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.Optional;
import lombok.Generated;
import org.apache.shardingsphere.infra.binder.context.available.WhereContextAvailable;
import org.apache.shardingsphere.infra.binder.context.segment.table.TablesContext;
import org.apache.shardingsphere.infra.binder.context.statement.SQLStatementContext;
import org.apache.shardingsphere.infra.binder.context.statement.type.dml.SelectStatementContext;
import org.apache.shardingsphere.infra.metadata.ShardingSphereMetaData;
import org.apache.shardingsphere.sql.parser.statement.core.enums.SubqueryType;
import org.apache.shardingsphere.sql.parser.statement.core.extractor.TableExtractor;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.column.ColumnSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.expr.BinaryOperationExpression;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.predicate.WhereSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.generic.table.SimpleTableSegment;
import org.apache.shardingsphere.sql.parser.statement.core.statement.type.ddl.view.AlterViewStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.type.dml.SelectStatement;

public final class AlterViewStatementContext
implements SQLStatementContext,
WhereContextAvailable {
    private final AlterViewStatement sqlStatement;
    private final TablesContext tablesContext;
    private final SelectStatementContext selectStatementContext;

    public AlterViewStatementContext(ShardingSphereMetaData metaData, AlterViewStatement sqlStatement, String currentDatabaseName) {
        this.sqlStatement = sqlStatement;
        LinkedList<SimpleTableSegment> tables = new LinkedList<SimpleTableSegment>();
        tables.add(sqlStatement.getView());
        Optional selectStatement = sqlStatement.getSelect();
        selectStatement.ifPresent(optional -> this.extractTables((SelectStatement)optional, (Collection<SimpleTableSegment>)tables));
        sqlStatement.getRenameView().ifPresent(tables::add);
        this.tablesContext = new TablesContext(tables);
        this.selectStatementContext = selectStatement.map(optional -> this.createSelectStatementContext(metaData, (SelectStatement)optional, currentDatabaseName)).orElse(null);
    }

    private SelectStatementContext createSelectStatementContext(ShardingSphereMetaData metaData, SelectStatement selectStatement, String currentDatabaseName) {
        SelectStatementContext result = new SelectStatementContext(selectStatement, metaData, currentDatabaseName, Collections.emptyList());
        result.setSubqueryType(SubqueryType.VIEW_DEFINITION);
        return result;
    }

    private void extractTables(SelectStatement selectStatement, Collection<SimpleTableSegment> tables) {
        TableExtractor extractor = new TableExtractor();
        extractor.extractTablesFromSelect(selectStatement);
        tables.addAll(extractor.getRewriteTables());
    }

    public Optional<SelectStatementContext> getSelectStatementContext() {
        return Optional.ofNullable(this.selectStatementContext);
    }

    @Override
    public Collection<WhereSegment> getWhereSegments() {
        return this.getSelectStatementContext().isPresent() ? this.getSelectStatementContext().get().getWhereSegments() : Collections.emptyList();
    }

    @Override
    public Collection<ColumnSegment> getColumnSegments() {
        return this.getSelectStatementContext().isPresent() ? this.getSelectStatementContext().get().getColumnSegments() : Collections.emptyList();
    }

    @Override
    public Collection<BinaryOperationExpression> getJoinConditions() {
        return this.getSelectStatementContext().isPresent() ? this.getSelectStatementContext().get().getJoinConditions() : Collections.emptyList();
    }

    @Generated
    public AlterViewStatement getSqlStatement() {
        return this.sqlStatement;
    }

    @Override
    @Generated
    public TablesContext getTablesContext() {
        return this.tablesContext;
    }
}

