/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.binder.context.statement.type.dal;

import java.util.Collections;
import lombok.Generated;
import org.apache.shardingsphere.infra.binder.context.SQLStatementContextFactory;
import org.apache.shardingsphere.infra.binder.context.segment.table.TablesContext;
import org.apache.shardingsphere.infra.binder.context.statement.SQLStatementContext;
import org.apache.shardingsphere.infra.metadata.ShardingSphereMetaData;
import org.apache.shardingsphere.sql.parser.statement.core.statement.attribute.type.TableSQLStatementAttribute;
import org.apache.shardingsphere.sql.parser.statement.core.statement.type.dal.ExplainStatement;

public final class ExplainStatementContext
implements SQLStatementContext {
    private final ExplainStatement sqlStatement;
    private final TablesContext tablesContext;
    private final SQLStatementContext explainableSQLStatementContext;

    public ExplainStatementContext(ShardingSphereMetaData metaData, ExplainStatement sqlStatement, String currentDatabaseName) {
        this.sqlStatement = sqlStatement;
        this.tablesContext = new TablesContext(sqlStatement.getAttributes().findAttribute(TableSQLStatementAttribute.class).map(TableSQLStatementAttribute::getTables).orElse(Collections.emptyList()));
        this.explainableSQLStatementContext = SQLStatementContextFactory.newInstance(metaData, sqlStatement.getExplainableSQLStatement(), currentDatabaseName);
    }

    @Generated
    public ExplainStatement getSqlStatement() {
        return this.sqlStatement;
    }

    @Override
    @Generated
    public TablesContext getTablesContext() {
        return this.tablesContext;
    }

    @Generated
    public SQLStatementContext getExplainableSQLStatementContext() {
        return this.explainableSQLStatementContext;
    }
}

