/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.binder.context.segment.table;

import com.cedarsoftware.util.CaseInsensitiveSet;
import com.google.common.base.Strings;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.Optional;
import lombok.Generated;
import org.apache.shardingsphere.sql.parser.statement.core.segment.generic.table.SimpleTableSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.generic.table.TableNameSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.generic.table.TableSegment;

public final class TablesContext {
    private final Collection<SimpleTableSegment> simpleTables = new LinkedList<SimpleTableSegment>();
    private final Collection<String> tableNames = new CaseInsensitiveSet();
    private final Collection<String> schemaNames = new CaseInsensitiveSet();
    private final Collection<String> databaseNames = new CaseInsensitiveSet();

    public TablesContext(SimpleTableSegment table) {
        this(null == table ? Collections.emptyList() : Collections.singletonList(table));
    }

    public TablesContext(Collection<? extends TableSegment> tables) {
        for (TableSegment tableSegment : tables) {
            SimpleTableSegment simpleTable;
            TableNameSegment tableName;
            if (!(tableSegment instanceof SimpleTableSegment) || "DUAL".equalsIgnoreCase((tableName = (simpleTable = (SimpleTableSegment)tableSegment).getTableName()).getIdentifier().getValue())) continue;
            this.handleSimpleTable(simpleTable, tableName);
        }
    }

    private void handleSimpleTable(SimpleTableSegment simpleTable, TableNameSegment tableName) {
        this.simpleTables.add(simpleTable);
        this.tableNames.add(tableName.getIdentifier().getValue());
        tableName.getTableBoundInfo().filter(optional -> !Strings.isNullOrEmpty((String)optional.getOriginalSchema().getValue())).ifPresent(optional -> this.schemaNames.add(optional.getOriginalSchema().getValue()));
        tableName.getTableBoundInfo().filter(optional -> !Strings.isNullOrEmpty((String)optional.getOriginalDatabase().getValue())).ifPresent(optional -> this.databaseNames.add(optional.getOriginalDatabase().getValue()));
    }

    public Optional<String> getDatabaseName() {
        return this.databaseNames.isEmpty() ? Optional.empty() : Optional.of(this.databaseNames.iterator().next());
    }

    public Optional<String> getSchemaName() {
        return this.schemaNames.isEmpty() ? Optional.empty() : Optional.of(this.schemaNames.iterator().next());
    }

    @Generated
    public Collection<SimpleTableSegment> getSimpleTables() {
        return this.simpleTables;
    }

    @Generated
    public Collection<String> getTableNames() {
        return this.tableNames;
    }

    @Generated
    public Collection<String> getSchemaNames() {
        return this.schemaNames;
    }

    @Generated
    public Collection<String> getDatabaseNames() {
        return this.databaseNames;
    }

    @Generated
    public String toString() {
        return "TablesContext(simpleTables=" + this.getSimpleTables() + ", tableNames=" + this.getTableNames() + ", schemaNames=" + this.getSchemaNames() + ", databaseNames=" + this.getDatabaseNames() + ")";
    }
}

