/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.binder.context.segment.select.subquery.engine;

import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import org.apache.shardingsphere.infra.binder.context.segment.select.projection.Projection;
import org.apache.shardingsphere.infra.binder.context.segment.select.projection.impl.ColumnProjection;
import org.apache.shardingsphere.infra.binder.context.segment.select.subquery.SubqueryTableContext;
import org.apache.shardingsphere.infra.binder.context.statement.type.dml.SelectStatementContext;
import org.apache.shardingsphere.sql.parser.statement.core.segment.generic.table.JoinTableSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.generic.table.SimpleTableSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.generic.table.TableSegment;

public final class SubqueryTableContextEngine {
    public Map<String, SubqueryTableContext> createSubqueryTableContexts(SelectStatementContext subqueryContext, String aliasName) {
        LinkedHashMap<String, SubqueryTableContext> result = new LinkedHashMap<String, SubqueryTableContext>(subqueryContext.getProjectionsContext().getExpandProjections().size(), 1.0f);
        TableSegment tableSegment = subqueryContext.getSqlStatement().getFrom().orElse(null);
        for (Projection each : subqueryContext.getProjectionsContext().getExpandProjections()) {
            Object tableName;
            if (!(each instanceof ColumnProjection)) continue;
            String columnName = ((ColumnProjection)each).getName().getValue();
            if (tableSegment instanceof SimpleTableSegment) {
                tableName = ((SimpleTableSegment)tableSegment).getTableName().getIdentifier().getValue();
                result.computeIfAbsent(((String)tableName).toLowerCase(), arg_0 -> SubqueryTableContextEngine.lambda$createSubqueryTableContexts$0((String)tableName, aliasName, arg_0)).getColumnNames().add(columnName);
            }
            if (!(tableSegment instanceof JoinTableSegment) || !((ColumnProjection)each).getOwner().isPresent()) continue;
            tableName = this.getTableNameByOwner(subqueryContext.getTablesContext().getSimpleTables(), ((ColumnProjection)each).getOwner().get().getValue());
            ((Optional)tableName).ifPresent(optional -> result.computeIfAbsent(optional.toLowerCase(), unused -> new SubqueryTableContext((String)optional, aliasName)).getColumnNames().add(columnName));
        }
        return result;
    }

    private Optional<String> getTableNameByOwner(Collection<SimpleTableSegment> simpleTableSegments, String owner) {
        for (SimpleTableSegment each : simpleTableSegments) {
            String tableNameOrAlias = each.getAliasName().orElseGet(() -> each.getTableName().getIdentifier().getValue());
            if (!tableNameOrAlias.equalsIgnoreCase(owner)) continue;
            return Optional.of(each.getTableName().getIdentifier().getValue());
        }
        return Optional.empty();
    }

    private static /* synthetic */ SubqueryTableContext lambda$createSubqueryTableContexts$0(String tableName, String aliasName, String unused) {
        return new SubqueryTableContext(tableName, aliasName);
    }
}

