/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.binder.context.segment.select.projection.impl;

import java.util.Optional;
import lombok.Generated;
import org.apache.shardingsphere.database.connector.core.type.DatabaseType;
import org.apache.shardingsphere.infra.binder.context.segment.select.projection.Projection;
import org.apache.shardingsphere.infra.binder.context.segment.select.projection.extractor.ProjectionIdentifierExtractEngine;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.item.SubqueryProjectionSegment;
import org.apache.shardingsphere.sql.parser.statement.core.value.identifier.IdentifierValue;

public final class SubqueryProjection
implements Projection {
    private final SubqueryProjectionSegment subquerySegment;
    private final Projection projection;
    private final IdentifierValue alias;
    private final DatabaseType databaseType;

    @Override
    public String getColumnName() {
        return this.getColumnLabel();
    }

    @Override
    public String getColumnLabel() {
        ProjectionIdentifierExtractEngine extractEngine = new ProjectionIdentifierExtractEngine(this.databaseType);
        return this.getAlias().map(extractEngine::getIdentifierValue).orElseGet(() -> extractEngine.getColumnNameFromSubquery(this.subquerySegment));
    }

    @Override
    public Optional<IdentifierValue> getAlias() {
        return Optional.ofNullable(this.alias);
    }

    @Override
    public String getExpression() {
        return this.subquerySegment.getText();
    }

    @Generated
    public SubqueryProjection(SubqueryProjectionSegment subquerySegment, Projection projection, IdentifierValue alias, DatabaseType databaseType) {
        this.subquerySegment = subquerySegment;
        this.projection = projection;
        this.alias = alias;
        this.databaseType = databaseType;
    }

    @Generated
    public SubqueryProjectionSegment getSubquerySegment() {
        return this.subquerySegment;
    }

    @Generated
    public Projection getProjection() {
        return this.projection;
    }

    @Generated
    public DatabaseType getDatabaseType() {
        return this.databaseType;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SubqueryProjection)) {
            return false;
        }
        SubqueryProjection other = (SubqueryProjection)o;
        SubqueryProjectionSegment this$subquerySegment = this.getSubquerySegment();
        SubqueryProjectionSegment other$subquerySegment = other.getSubquerySegment();
        if (this$subquerySegment == null ? other$subquerySegment != null : !this$subquerySegment.equals(other$subquerySegment)) {
            return false;
        }
        Projection this$projection = this.getProjection();
        Projection other$projection = other.getProjection();
        if (this$projection == null ? other$projection != null : !this$projection.equals(other$projection)) {
            return false;
        }
        Optional<IdentifierValue> this$alias = this.getAlias();
        Optional<IdentifierValue> other$alias = other.getAlias();
        if (this$alias == null ? other$alias != null : !((Object)this$alias).equals(other$alias)) {
            return false;
        }
        DatabaseType this$databaseType = this.getDatabaseType();
        DatabaseType other$databaseType = other.getDatabaseType();
        return !(this$databaseType == null ? other$databaseType != null : !this$databaseType.equals(other$databaseType));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        SubqueryProjectionSegment $subquerySegment = this.getSubquerySegment();
        result = result * 59 + ($subquerySegment == null ? 43 : $subquerySegment.hashCode());
        Projection $projection = this.getProjection();
        result = result * 59 + ($projection == null ? 43 : $projection.hashCode());
        Optional<IdentifierValue> $alias = this.getAlias();
        result = result * 59 + ($alias == null ? 43 : ((Object)$alias).hashCode());
        DatabaseType $databaseType = this.getDatabaseType();
        result = result * 59 + ($databaseType == null ? 43 : $databaseType.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "SubqueryProjection(subquerySegment=" + this.getSubquerySegment() + ", projection=" + this.getProjection() + ", alias=" + this.getAlias() + ", databaseType=" + this.getDatabaseType() + ")";
    }
}

