/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.binder.context.segment.select.pagination.engine;

import java.util.Collections;
import java.util.List;
import java.util.Optional;
import lombok.Generated;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.item.ProjectionSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.item.SubqueryProjectionSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.pagination.top.TopProjectionSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.generic.table.SubqueryTableSegment;
import org.apache.shardingsphere.sql.parser.statement.core.statement.type.dml.SelectStatement;
import org.apache.shardingsphere.sql.parser.statement.core.util.SQLUtils;

public final class TopProjectionExtractor {
    public static Optional<TopProjectionSegment> findTopProjection(SelectStatement selectStatement) {
        for (ProjectionSegment each : selectStatement.getProjections().getProjections()) {
            if (!(each instanceof SubqueryProjectionSegment)) continue;
            return TopProjectionExtractor.findTopProjection0(((SubqueryProjectionSegment)each).getSubquery().getSelect());
        }
        return TopProjectionExtractor.findTopProjection0(selectStatement);
    }

    private static Optional<TopProjectionSegment> findTopProjection0(SelectStatement selectStatement) {
        for (ProjectionSegment each : selectStatement.getProjections().getProjections()) {
            if (!(each instanceof TopProjectionSegment)) continue;
            return Optional.of((TopProjectionSegment)each);
        }
        List subqueryTableSegments = selectStatement.getFrom().map(SQLUtils::getSubqueryTableSegmentFromTableSegment).orElse(Collections.emptyList());
        for (SubqueryTableSegment subquery : subqueryTableSegments) {
            SelectStatement subquerySelect = subquery.getSubquery().getSelect();
            for (ProjectionSegment each : subquerySelect.getProjections().getProjections()) {
                if (!(each instanceof TopProjectionSegment)) continue;
                return Optional.of((TopProjectionSegment)each);
            }
        }
        return Optional.empty();
    }

    @Generated
    private TopProjectionExtractor() {
    }
}

