/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.single.util;

import com.cedarsoftware.util.CaseInsensitiveSet;
import com.google.common.base.Splitter;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Optional;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.shardingsphere.database.connector.core.metadata.database.metadata.DialectDatabaseMetaData;
import org.apache.shardingsphere.database.connector.core.type.DatabaseType;
import org.apache.shardingsphere.database.connector.core.type.DatabaseTypeRegistry;
import org.apache.shardingsphere.infra.datanode.DataNode;
import org.apache.shardingsphere.infra.rule.ShardingSphereRule;
import org.apache.shardingsphere.infra.rule.attribute.table.TableMapperRuleAttribute;

public final class SingleTableLoadUtils {
    private static final String DELIMITER = ",";

    public static Collection<String> getExcludedTables(Collection<ShardingSphereRule> builtRules) {
        CaseInsensitiveSet result = new CaseInsensitiveSet();
        for (ShardingSphereRule each : builtRules) {
            Optional ruleAttribute = each.getAttributes().findAttribute(TableMapperRuleAttribute.class);
            if (!ruleAttribute.isPresent()) continue;
            result.addAll(((TableMapperRuleAttribute)ruleAttribute.get()).getDistributedTableNames());
            result.addAll(((TableMapperRuleAttribute)ruleAttribute.get()).getActualTableNames());
        }
        return result;
    }

    public static Collection<String> getFeatureRequiredSingleTables(Collection<ShardingSphereRule> builtRules) {
        CaseInsensitiveSet result = new CaseInsensitiveSet();
        for (ShardingSphereRule each : builtRules) {
            Optional ruleAttribute = each.getAttributes().findAttribute(TableMapperRuleAttribute.class);
            if (!ruleAttribute.isPresent() || ((TableMapperRuleAttribute)ruleAttribute.get()).getEnhancedTableNames().isEmpty() || !((TableMapperRuleAttribute)ruleAttribute.get()).getDistributedTableNames().isEmpty()) continue;
            result.addAll(((TableMapperRuleAttribute)ruleAttribute.get()).getEnhancedTableNames());
        }
        return result;
    }

    public static Collection<String> splitTableLines(Collection<String> tables) {
        LinkedHashSet<String> result = new LinkedHashSet<String>();
        for (String each : tables) {
            if (each.contains(DELIMITER)) {
                result.addAll(Splitter.on((String)DELIMITER).omitEmptyStrings().splitToList((CharSequence)each));
                continue;
            }
            result.add(each);
        }
        return result;
    }

    public static Collection<DataNode> convertToDataNodes(String databaseName, DatabaseType databaseType, Collection<String> dataNodes) {
        return dataNodes.stream().map(each -> new DataNode(databaseName, databaseType, each)).collect(Collectors.toCollection(() -> new LinkedHashSet(dataNodes.size(), 1.0f)));
    }

    public static String getAllTablesNodeStr(DatabaseType databaseType) {
        DialectDatabaseMetaData dialectDatabaseMetaData = new DatabaseTypeRegistry(databaseType).getDialectDatabaseMetaData();
        return dialectDatabaseMetaData.getSchemaOption().getDefaultSchema().isPresent() ? "*.*.*" : "*.*";
    }

    public static String getAllTablesNodeStrFromDataSource(DatabaseType databaseType, String dataSourceName, String schemaName) {
        DialectDatabaseMetaData dialectDatabaseMetaData = new DatabaseTypeRegistry(databaseType).getDialectDatabaseMetaData();
        return dialectDatabaseMetaData.getSchemaOption().getDefaultSchema().isPresent() ? SingleTableLoadUtils.formatDataNode(dataSourceName, schemaName, "*") : SingleTableLoadUtils.formatDataNode(dataSourceName, "*");
    }

    public static String getDataNodeString(DatabaseType databaseType, String dataSourceName, String schemaName, String tableName) {
        DialectDatabaseMetaData dialectDatabaseMetaData = new DatabaseTypeRegistry(databaseType).getDialectDatabaseMetaData();
        return dialectDatabaseMetaData.getSchemaOption().getDefaultSchema().isPresent() ? SingleTableLoadUtils.formatDataNode(dataSourceName, schemaName, tableName) : SingleTableLoadUtils.formatDataNode(dataSourceName, tableName);
    }

    private static String formatDataNode(String dataSourceName, String tableName) {
        return String.format("%s.%s", dataSourceName, tableName);
    }

    private static String formatDataNode(String dataSourceName, String schemaName, String tableName) {
        return String.format("%s.%s.%s", dataSourceName, schemaName, tableName);
    }

    @Generated
    private SingleTableLoadUtils() {
    }
}

