/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.single.decorator;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.sql.DataSource;
import lombok.Generated;
import org.apache.shardingsphere.database.connector.core.type.DatabaseType;
import org.apache.shardingsphere.database.connector.core.type.DatabaseTypeRegistry;
import org.apache.shardingsphere.infra.config.rule.decorator.RuleConfigurationDecorator;
import org.apache.shardingsphere.infra.database.DatabaseTypeEngine;
import org.apache.shardingsphere.infra.datanode.DataNode;
import org.apache.shardingsphere.infra.exception.ShardingSpherePreconditions;
import org.apache.shardingsphere.infra.metadata.database.resource.PhysicalDataSourceAggregator;
import org.apache.shardingsphere.infra.rule.ShardingSphereRule;
import org.apache.shardingsphere.single.config.SingleRuleConfiguration;
import org.apache.shardingsphere.single.datanode.SingleTableDataNodeLoader;
import org.apache.shardingsphere.single.exception.InvalidSingleRuleConfigurationException;
import org.apache.shardingsphere.single.exception.SingleTableNotFoundException;
import org.apache.shardingsphere.single.rule.SingleRule;
import org.apache.shardingsphere.single.util.SingleTableLoadUtils;

public final class SingleRuleConfigurationDecorator
implements RuleConfigurationDecorator<SingleRuleConfiguration> {
    public SingleRuleConfiguration decorate(String databaseName, Map<String, DataSource> dataSources, Collection<ShardingSphereRule> builtRules, SingleRuleConfiguration ruleConfig) {
        return new SingleRuleConfiguration(this.decorateTables(databaseName, dataSources, new LinkedList<ShardingSphereRule>(builtRules), ruleConfig.getTables()), (String)ruleConfig.getDefaultDataSource().orElse(null));
    }

    private Collection<String> decorateTables(String databaseName, Map<String, DataSource> dataSources, Collection<ShardingSphereRule> builtRules, Collection<String> tables) {
        builtRules.removeIf(SingleRule.class::isInstance);
        if (tables.isEmpty() && builtRules.isEmpty()) {
            return Collections.emptyList();
        }
        Collection<String> splitTables = SingleTableLoadUtils.splitTableLines(tables);
        if (!this.isExpandRequired(splitTables)) {
            return splitTables;
        }
        Map aggregatedDataSources = PhysicalDataSourceAggregator.getAggregatedDataSources(dataSources, builtRules);
        DatabaseType databaseType = dataSources.isEmpty() ? DatabaseTypeEngine.getDefaultStorageType() : DatabaseTypeEngine.getStorageType((DataSource)dataSources.values().iterator().next());
        Collection<String> excludedTables = SingleTableLoadUtils.getExcludedTables(builtRules);
        Map<String, Collection<DataNode>> actualDataNodes = SingleTableDataNodeLoader.load(databaseName, aggregatedDataSources, excludedTables);
        boolean isSchemaAvailable = new DatabaseTypeRegistry(databaseType).getDialectDatabaseMetaData().getSchemaOption().isSchemaAvailable();
        if (splitTables.contains("*.*") || splitTables.contains("*.*.*")) {
            return this.loadAllTables(isSchemaAvailable, actualDataNodes);
        }
        Collection<DataNode> configuredDataNodes = SingleTableLoadUtils.convertToDataNodes(databaseName, databaseType, splitTables);
        return this.loadSpecifiedTables(isSchemaAvailable, actualDataNodes, builtRules, configuredDataNodes);
    }

    private boolean isExpandRequired(Collection<String> splitTables) {
        return splitTables.stream().anyMatch(each -> each.contains("*"));
    }

    private Collection<String> loadAllTables(boolean isSchemaAvailable, Map<String, Collection<DataNode>> actualDataNodes) {
        LinkedList<String> result = new LinkedList<String>();
        for (Map.Entry<String, Collection<DataNode>> entry : actualDataNodes.entrySet()) {
            result.addAll(entry.getValue().stream().map(each -> this.getTableNodeString(isSchemaAvailable, (DataNode)each)).collect(Collectors.toList()));
        }
        return result;
    }

    private String getTableNodeString(boolean isSchemaAvailable, DataNode dataNode) {
        return isSchemaAvailable ? this.formatTableName(dataNode.getDataSourceName(), dataNode.getSchemaName(), dataNode.getTableName()) : this.formatTableName(dataNode.getDataSourceName(), dataNode.getTableName());
    }

    private String formatTableName(String dataSourceName, String schemaName, String tableName) {
        return String.format("%s.%s.%s", dataSourceName, schemaName, tableName);
    }

    private String formatTableName(String dataSourceName, String tableName) {
        return String.format("%s.%s", dataSourceName, tableName);
    }

    private Collection<String> loadSpecifiedTables(boolean isSchemaAvailable, Map<String, Collection<DataNode>> actualDataNodes, Collection<ShardingSphereRule> builtRules, Collection<DataNode> configuredDataNodes) {
        DataNodeClassification dataNodeClassification = this.classifyDataNodes(configuredDataNodes);
        if (dataNodeClassification.expandDataSources.isEmpty() && dataNodeClassification.expandDataSourceSchemas.isEmpty()) {
            return this.loadSpecifiedTablesWithoutExpand(isSchemaAvailable, actualDataNodes, configuredDataNodes);
        }
        return this.loadSpecifiedTablesWithExpand(isSchemaAvailable, actualDataNodes, SingleTableLoadUtils.getFeatureRequiredSingleTables(builtRules), dataNodeClassification.getExpandDataSources(), dataNodeClassification.getExpandDataSourceSchemas(), dataNodeClassification.getExpectedDataNodes());
    }

    private DataNodeClassification classifyDataNodes(Collection<DataNode> configuredDataNodes) {
        LinkedHashSet<String> expandDataSources = new LinkedHashSet<String>();
        LinkedHashMap<String, Set<String>> expandDataSourceSchemas = new LinkedHashMap<String, Set<String>>();
        LinkedHashMap<String, DataNode> expectedDataNodes = new LinkedHashMap<String, DataNode>();
        for (DataNode each : configuredDataNodes) {
            this.categorizeDataNode(each, expandDataSources, expandDataSourceSchemas, expectedDataNodes);
        }
        return new DataNodeClassification(expandDataSources, expandDataSourceSchemas, expectedDataNodes);
    }

    private void categorizeDataNode(DataNode dataNode, Collection<String> expandDataSources, Map<String, Set<String>> expandDataSourceSchemas, Map<String, DataNode> expectedDataNodes) {
        if ("*".equals(dataNode.getTableName())) {
            if ("*".equals(dataNode.getSchemaName())) {
                expandDataSources.add(dataNode.getDataSourceName());
            } else {
                expandDataSourceSchemas.computeIfAbsent(dataNode.getDataSourceName(), key -> new LinkedHashSet()).add(dataNode.getSchemaName());
            }
        } else {
            expectedDataNodes.put(dataNode.getTableName(), dataNode);
        }
    }

    private Collection<String> loadSpecifiedTablesWithExpand(boolean isSchemaAvailable, Map<String, Collection<DataNode>> actualDataNodes, Collection<String> featureRequiredSingleTables, Collection<String> expandDataSources, Map<String, Set<String>> expandDataSourceSchemas, Map<String, DataNode> expectedDataNodes) {
        LinkedHashSet<String> result = new LinkedHashSet<String>(actualDataNodes.size(), 1.0f);
        for (Map.Entry<String, Collection<DataNode>> entry : actualDataNodes.entrySet()) {
            if (featureRequiredSingleTables.contains(entry.getKey())) continue;
            DataNode physicalDataNode = entry.getValue().iterator().next();
            if (expandDataSources.contains(physicalDataNode.getDataSourceName())) {
                result.add(this.getTableNodeString(isSchemaAvailable, physicalDataNode));
                continue;
            }
            Set<String> requiredSchemas = expandDataSourceSchemas.get(physicalDataNode.getDataSourceName());
            if (null != requiredSchemas && requiredSchemas.contains(physicalDataNode.getSchemaName())) {
                result.add(this.getTableNodeString(isSchemaAvailable, physicalDataNode));
                continue;
            }
            if (!expectedDataNodes.containsKey(entry.getKey())) continue;
            DataNode dataNode = expectedDataNodes.get(entry.getKey());
            String tableNodeStr = this.getTableNodeString(isSchemaAvailable, physicalDataNode);
            ShardingSpherePreconditions.checkState((boolean)physicalDataNode.equals((Object)dataNode), () -> new InvalidSingleRuleConfigurationException(String.format("Single table `%s` is found that does not match %s", tableNodeStr, this.getTableNodeString(isSchemaAvailable, dataNode))));
            result.add(tableNodeStr);
        }
        return result;
    }

    private Collection<String> loadSpecifiedTablesWithoutExpand(boolean isSchemaAvailable, Map<String, Collection<DataNode>> actualDataNodes, Collection<DataNode> configuredDataNodes) {
        LinkedHashSet<String> result = new LinkedHashSet<String>(configuredDataNodes.size(), 1.0f);
        for (DataNode each : configuredDataNodes) {
            ShardingSpherePreconditions.checkContainsKey(actualDataNodes, (Object)each.getTableName(), () -> new SingleTableNotFoundException(this.getTableNodeString(isSchemaAvailable, each)));
            DataNode actualDataNode = actualDataNodes.get(each.getTableName()).iterator().next();
            String tableNodeStr = this.getTableNodeString(isSchemaAvailable, actualDataNode);
            ShardingSpherePreconditions.checkState((boolean)actualDataNode.equals((Object)each), () -> new InvalidSingleRuleConfigurationException(String.format("Single table '%s' is found that does not match %s", tableNodeStr, this.getTableNodeString(isSchemaAvailable, each))));
            result.add(tableNodeStr);
        }
        return result;
    }

    public Class<SingleRuleConfiguration> getType() {
        return SingleRuleConfiguration.class;
    }

    private static class DataNodeClassification {
        private final Collection<String> expandDataSources;
        private final Map<String, Set<String>> expandDataSourceSchemas;
        private final Map<String, DataNode> expectedDataNodes;

        @Generated
        public Collection<String> getExpandDataSources() {
            return this.expandDataSources;
        }

        @Generated
        public Map<String, Set<String>> getExpandDataSourceSchemas() {
            return this.expandDataSourceSchemas;
        }

        @Generated
        public Map<String, DataNode> getExpectedDataNodes() {
            return this.expectedDataNodes;
        }

        @Generated
        public DataNodeClassification(Collection<String> expandDataSources, Map<String, Set<String>> expandDataSourceSchemas, Map<String, DataNode> expectedDataNodes) {
            this.expandDataSources = expandDataSources;
            this.expandDataSourceSchemas = expandDataSourceSchemas;
            this.expectedDataNodes = expectedDataNodes;
        }
    }
}

