/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.binder.mysql.bind;

import java.util.Optional;
import org.apache.shardingsphere.infra.binder.engine.DialectSQLBindEngine;
import org.apache.shardingsphere.infra.binder.engine.statement.SQLStatementBinderContext;
import org.apache.shardingsphere.infra.binder.mysql.bind.type.MySQLLoadDataStatementBinder;
import org.apache.shardingsphere.infra.binder.mysql.bind.type.MySQLLoadXMLStatementBinder;
import org.apache.shardingsphere.infra.binder.mysql.bind.type.MySQLOptimizeTableStatementBinder;
import org.apache.shardingsphere.infra.binder.mysql.bind.type.MySQLShowColumnsStatementBinder;
import org.apache.shardingsphere.infra.binder.mysql.bind.type.MySQLShowCreateTableStatementBinder;
import org.apache.shardingsphere.infra.binder.mysql.bind.type.MySQLShowIndexStatementBinder;
import org.apache.shardingsphere.sql.parser.statement.core.statement.SQLStatement;
import org.apache.shardingsphere.sql.parser.statement.mysql.dal.show.column.MySQLShowColumnsStatement;
import org.apache.shardingsphere.sql.parser.statement.mysql.dal.show.index.MySQLShowIndexStatement;
import org.apache.shardingsphere.sql.parser.statement.mysql.dal.show.table.MySQLShowCreateTableStatement;
import org.apache.shardingsphere.sql.parser.statement.mysql.dal.table.MySQLOptimizeTableStatement;
import org.apache.shardingsphere.sql.parser.statement.mysql.dml.MySQLLoadDataStatement;
import org.apache.shardingsphere.sql.parser.statement.mysql.dml.MySQLLoadXMLStatement;

public final class MySQLSQLBindEngine
implements DialectSQLBindEngine {
    public Optional<SQLStatement> bind(SQLStatement sqlStatement, SQLStatementBinderContext binderContext) {
        if (sqlStatement instanceof MySQLLoadDataStatement) {
            return Optional.of(new MySQLLoadDataStatementBinder().bind((MySQLLoadDataStatement)sqlStatement, binderContext));
        }
        if (sqlStatement instanceof MySQLLoadXMLStatement) {
            return Optional.of(new MySQLLoadXMLStatementBinder().bind((MySQLLoadXMLStatement)sqlStatement, binderContext));
        }
        if (sqlStatement instanceof MySQLOptimizeTableStatement) {
            return Optional.of(new MySQLOptimizeTableStatementBinder().bind((MySQLOptimizeTableStatement)sqlStatement, binderContext));
        }
        if (sqlStatement instanceof MySQLShowCreateTableStatement) {
            return Optional.of(new MySQLShowCreateTableStatementBinder().bind((MySQLShowCreateTableStatement)sqlStatement, binderContext));
        }
        if (sqlStatement instanceof MySQLShowColumnsStatement) {
            return Optional.of(new MySQLShowColumnsStatementBinder().bind((MySQLShowColumnsStatement)sqlStatement, binderContext));
        }
        if (sqlStatement instanceof MySQLShowIndexStatement) {
            return Optional.of(new MySQLShowIndexStatementBinder().bind((MySQLShowIndexStatement)sqlStatement, binderContext));
        }
        return Optional.empty();
    }

    public String getDatabaseType() {
        return "MySQL";
    }
}

