/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sql.parser.engine.postgresql.visitor.statement.type;

import org.apache.shardingsphere.database.connector.core.type.DatabaseType;
import org.apache.shardingsphere.sql.parser.api.ASTNode;
import org.apache.shardingsphere.sql.parser.api.visitor.statement.type.TCLStatementVisitor;
import org.apache.shardingsphere.sql.parser.autogen.PostgreSQLStatementParser;
import org.apache.shardingsphere.sql.parser.engine.postgresql.visitor.statement.PostgreSQLStatementVisitor;
import org.apache.shardingsphere.sql.parser.statement.core.enums.TransactionAccessType;
import org.apache.shardingsphere.sql.parser.statement.core.enums.TransactionIsolationLevel;
import org.apache.shardingsphere.sql.parser.statement.core.statement.type.tcl.BeginTransactionStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.type.tcl.CommitStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.type.tcl.ReleaseSavepointStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.type.tcl.RollbackStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.type.tcl.SavepointStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.type.tcl.SetConstraintsStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.type.tcl.SetTransactionStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.type.tcl.StartTransactionStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.type.tcl.xa.XACommitStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.type.tcl.xa.XAPrepareStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.type.tcl.xa.XARollbackStatement;

public final class PostgreSQLTCLStatementVisitor
extends PostgreSQLStatementVisitor
implements TCLStatementVisitor {
    public PostgreSQLTCLStatementVisitor(DatabaseType databaseType) {
        super(databaseType);
    }

    @Override
    public ASTNode visitSetTransaction(PostgreSQLStatementParser.SetTransactionContext ctx) {
        SetTransactionStatement result = new SetTransactionStatement(this.getDatabaseType());
        if (null != ctx.transactionModeList()) {
            for (PostgreSQLStatementParser.TransactionModeItemContext each : ctx.transactionModeList().transactionModeItem()) {
                result = new SetTransactionStatement(this.getDatabaseType(), null, this.getTransactionIsolationLevel(each.isoLevel()), this.getTransactionAccessType(each));
            }
        }
        return result;
    }

    private TransactionIsolationLevel getTransactionIsolationLevel(PostgreSQLStatementParser.IsoLevelContext ctx) {
        if (null == ctx) {
            return null;
        }
        if (null != ctx.UNCOMMITTED()) {
            return TransactionIsolationLevel.READ_UNCOMMITTED;
        }
        if (null != ctx.COMMITTED()) {
            return TransactionIsolationLevel.READ_COMMITTED;
        }
        if (null != ctx.REPEATABLE()) {
            return TransactionIsolationLevel.REPEATABLE_READ;
        }
        if (null != ctx.SERIALIZABLE()) {
            return TransactionIsolationLevel.SERIALIZABLE;
        }
        return null;
    }

    private TransactionAccessType getTransactionAccessType(PostgreSQLStatementParser.TransactionModeItemContext ctx) {
        if (null == ctx) {
            return null;
        }
        if (null != ctx.ONLY()) {
            return TransactionAccessType.READ_ONLY;
        }
        if (null != ctx.WRITE()) {
            return TransactionAccessType.READ_WRITE;
        }
        return null;
    }

    @Override
    public ASTNode visitBeginTransaction(PostgreSQLStatementParser.BeginTransactionContext ctx) {
        return new BeginTransactionStatement(this.getDatabaseType());
    }

    @Override
    public ASTNode visitCommit(PostgreSQLStatementParser.CommitContext ctx) {
        return new CommitStatement(this.getDatabaseType());
    }

    @Override
    public ASTNode visitRollback(PostgreSQLStatementParser.RollbackContext ctx) {
        return new RollbackStatement(this.getDatabaseType());
    }

    @Override
    public ASTNode visitAbort(PostgreSQLStatementParser.AbortContext ctx) {
        return new RollbackStatement(this.getDatabaseType());
    }

    @Override
    public ASTNode visitSavepoint(PostgreSQLStatementParser.SavepointContext ctx) {
        return new SavepointStatement(this.getDatabaseType(), ctx.colId().getText());
    }

    @Override
    public ASTNode visitRollbackToSavepoint(PostgreSQLStatementParser.RollbackToSavepointContext ctx) {
        return new RollbackStatement(this.getDatabaseType(), ctx.colId().getText());
    }

    @Override
    public ASTNode visitReleaseSavepoint(PostgreSQLStatementParser.ReleaseSavepointContext ctx) {
        return new ReleaseSavepointStatement(this.getDatabaseType(), ctx.colId().getText());
    }

    @Override
    public ASTNode visitStartTransaction(PostgreSQLStatementParser.StartTransactionContext ctx) {
        return new StartTransactionStatement(this.getDatabaseType());
    }

    @Override
    public ASTNode visitEnd(PostgreSQLStatementParser.EndContext ctx) {
        return new CommitStatement(this.getDatabaseType());
    }

    @Override
    public ASTNode visitSetConstraints(PostgreSQLStatementParser.SetConstraintsContext ctx) {
        return new SetConstraintsStatement(this.getDatabaseType());
    }

    @Override
    public ASTNode visitPrepareTransaction(PostgreSQLStatementParser.PrepareTransactionContext ctx) {
        return new XAPrepareStatement(this.getDatabaseType(), ctx.gid().getText());
    }

    @Override
    public ASTNode visitCommitPrepared(PostgreSQLStatementParser.CommitPreparedContext ctx) {
        return new XACommitStatement(this.getDatabaseType(), ctx.gid().getText());
    }

    @Override
    public ASTNode visitRollbackPrepared(PostgreSQLStatementParser.RollbackPreparedContext ctx) {
        return new XARollbackStatement(this.getDatabaseType(), ctx.gid().getText());
    }
}

