/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sql.parser.engine.postgresql.visitor.statement.type;

import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.antlr.v4.runtime.misc.Interval;
import org.antlr.v4.runtime.tree.ParseTree;
import org.apache.shardingsphere.database.connector.core.type.DatabaseType;
import org.apache.shardingsphere.sql.parser.api.ASTNode;
import org.apache.shardingsphere.sql.parser.api.visitor.statement.type.DMLStatementVisitor;
import org.apache.shardingsphere.sql.parser.autogen.PostgreSQLStatementParser;
import org.apache.shardingsphere.sql.parser.engine.postgresql.visitor.statement.PostgreSQLStatementVisitor;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.ReturningSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.expr.ExpressionSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.expr.complex.CommonExpressionSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.item.ProjectionsSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.prepare.PrepareStatementQuerySegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.generic.table.SimpleTableSegment;
import org.apache.shardingsphere.sql.parser.statement.core.statement.type.dml.CallStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.type.dml.DeleteStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.type.dml.DoStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.type.dml.InsertStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.type.dml.SelectStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.type.dml.UpdateStatement;
import org.apache.shardingsphere.sql.parser.statement.core.value.collection.CollectionValue;
import org.apache.shardingsphere.sql.parser.statement.core.value.identifier.IdentifierValue;
import org.apache.shardingsphere.sql.parser.statement.postgresql.dml.PostgreSQLCopyStatement;

public final class PostgreSQLDMLStatementVisitor
extends PostgreSQLStatementVisitor
implements DMLStatementVisitor {
    public PostgreSQLDMLStatementVisitor(DatabaseType databaseType) {
        super(databaseType);
    }

    @Override
    public ASTNode visitCall(PostgreSQLStatementParser.CallContext ctx) {
        String procedureName = ((IdentifierValue)this.visit((ParseTree)ctx.identifier())).getValue();
        List params = null == ctx.callArguments() ? Collections.emptyList() : ctx.callArguments().callArgument().stream().map(each -> (ExpressionSegment)this.visit((ParseTree)each)).collect(Collectors.toList());
        return new CallStatement(this.getDatabaseType(), procedureName, params);
    }

    @Override
    public ASTNode visitCallArgument(PostgreSQLStatementParser.CallArgumentContext ctx) {
        if (null == ctx.positionalNotation()) {
            String text = ctx.namedNotation().start.getInputStream().getText(new Interval(ctx.namedNotation().start.getStartIndex(), ctx.namedNotation().stop.getStopIndex()));
            return new CommonExpressionSegment(ctx.namedNotation().getStart().getStartIndex(), ctx.namedNotation().getStop().getStopIndex(), text);
        }
        return (ASTNode)this.visit((ParseTree)ctx.positionalNotation().aExpr());
    }

    @Override
    public ASTNode visitDoStatement(PostgreSQLStatementParser.DoStatementContext ctx) {
        return new DoStatement(this.getDatabaseType(), Collections.emptyList());
    }

    @Override
    public ASTNode visitCopy(PostgreSQLStatementParser.CopyContext ctx) {
        if (null != ctx.copyWithTableOrQuery()) {
            return (ASTNode)this.visit((ParseTree)ctx.copyWithTableOrQuery());
        }
        if (null != ctx.copyWithTableOrQueryBinaryCsv()) {
            return (ASTNode)this.visit((ParseTree)ctx.copyWithTableOrQueryBinaryCsv());
        }
        return (ASTNode)this.visit((ParseTree)ctx.copyWithTableBinary());
    }

    @Override
    public ASTNode visitCopyWithTableOrQuery(PostgreSQLStatementParser.CopyWithTableOrQueryContext ctx) {
        return new PostgreSQLCopyStatement(this.getDatabaseType(), null == ctx.qualifiedName() ? null : (SimpleTableSegment)this.visit((ParseTree)ctx.qualifiedName()), null == ctx.columnNames() ? Collections.emptyList() : ((CollectionValue)this.visit((ParseTree)ctx.columnNames())).getValue(), null == ctx.preparableStmt() ? null : this.extractPrepareStatementQuerySegmentFromPreparableStmt(ctx.preparableStmt()));
    }

    private PrepareStatementQuerySegment extractPrepareStatementQuerySegmentFromPreparableStmt(PostgreSQLStatementParser.PreparableStmtContext ctx) {
        PrepareStatementQuerySegment result = new PrepareStatementQuerySegment(ctx.start.getStartIndex(), ctx.stop.getStopIndex());
        if (null != ctx.select()) {
            result.setSelect((SelectStatement)this.visit((ParseTree)ctx.select()));
        } else if (null != ctx.insert()) {
            result.setInsert((InsertStatement)this.visit((ParseTree)ctx.insert()));
        } else if (null != ctx.update()) {
            result.setUpdate((UpdateStatement)this.visit((ParseTree)ctx.update()));
        } else {
            result.setDelete((DeleteStatement)this.visit((ParseTree)ctx.delete()));
        }
        return result;
    }

    @Override
    public ASTNode visitCopyWithTableOrQueryBinaryCsv(PostgreSQLStatementParser.CopyWithTableOrQueryBinaryCsvContext ctx) {
        return new PostgreSQLCopyStatement(this.getDatabaseType(), null == ctx.qualifiedName() ? null : (SimpleTableSegment)this.visit((ParseTree)ctx.qualifiedName()), null == ctx.columnNames() ? Collections.emptyList() : ((CollectionValue)this.visit((ParseTree)ctx.columnNames())).getValue(), null == ctx.preparableStmt() ? null : this.extractPrepareStatementQuerySegmentFromPreparableStmt(ctx.preparableStmt()));
    }

    @Override
    public ASTNode visitCopyWithTableBinary(PostgreSQLStatementParser.CopyWithTableBinaryContext ctx) {
        return new PostgreSQLCopyStatement(this.getDatabaseType(), null == ctx.qualifiedName() ? null : (SimpleTableSegment)this.visit((ParseTree)ctx.qualifiedName()), Collections.emptyList(), null);
    }

    @Override
    public ASTNode visitReturningClause(PostgreSQLStatementParser.ReturningClauseContext ctx) {
        return new ReturningSegment(ctx.start.getStartIndex(), ctx.stop.getStopIndex(), (ProjectionsSegment)this.visit((ParseTree)ctx.targetList()));
    }
}

