/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sql.parser.engine.postgresql.visitor.statement.type;

import java.util.Collection;
import java.util.Collections;
import org.antlr.v4.runtime.tree.ParseTree;
import org.apache.shardingsphere.database.connector.core.type.DatabaseType;
import org.apache.shardingsphere.sql.parser.api.ASTNode;
import org.apache.shardingsphere.sql.parser.api.visitor.statement.type.DCLStatementVisitor;
import org.apache.shardingsphere.sql.parser.autogen.PostgreSQLStatementParser;
import org.apache.shardingsphere.sql.parser.engine.postgresql.visitor.statement.PostgreSQLStatementVisitor;
import org.apache.shardingsphere.sql.parser.statement.core.segment.generic.table.SimpleTableSegment;
import org.apache.shardingsphere.sql.parser.statement.core.statement.type.dcl.GrantStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.type.dcl.RevokeStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.type.dcl.role.AlterRoleStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.type.dcl.role.CreateRoleStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.type.dcl.role.DropRoleStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.type.dcl.user.AlterUserStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.type.dcl.user.CreateUserStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.type.dcl.user.DropUserStatement;
import org.apache.shardingsphere.sql.parser.statement.core.value.collection.CollectionValue;
import org.apache.shardingsphere.sql.parser.statement.postgresql.dcl.PostgreSQLCreateGroupStatement;
import org.apache.shardingsphere.sql.parser.statement.postgresql.dcl.PostgreSQLReassignOwnedStatement;

public final class PostgreSQLDCLStatementVisitor
extends PostgreSQLStatementVisitor
implements DCLStatementVisitor {
    public PostgreSQLDCLStatementVisitor(DatabaseType databaseType) {
        super(databaseType);
    }

    @Override
    public ASTNode visitGrant(PostgreSQLStatementParser.GrantContext ctx) {
        GrantStatement result = new GrantStatement(this.getDatabaseType());
        if (this.containsTableSegment(ctx.privilegeClause())) {
            result.getTables().addAll(this.getTableSegments(ctx.privilegeClause()));
        }
        return result;
    }

    @Override
    public ASTNode visitRevoke(PostgreSQLStatementParser.RevokeContext ctx) {
        RevokeStatement result = new RevokeStatement(this.getDatabaseType());
        if (this.containsTableSegment(ctx.privilegeClause())) {
            result.getTables().addAll(this.getTableSegments(ctx.privilegeClause()));
        }
        return result;
    }

    private boolean containsTableSegment(PostgreSQLStatementParser.PrivilegeClauseContext ctx) {
        return null != ctx && null != ctx.onObjectClause() && null != ctx.onObjectClause().privilegeLevel() && null != ctx.onObjectClause().privilegeLevel().tableNames();
    }

    private Collection<SimpleTableSegment> getTableSegments(PostgreSQLStatementParser.PrivilegeClauseContext ctx) {
        return ((CollectionValue)this.visit((ParseTree)ctx.onObjectClause().privilegeLevel().tableNames())).getValue();
    }

    @Override
    public ASTNode visitCreateUser(PostgreSQLStatementParser.CreateUserContext ctx) {
        return new CreateUserStatement(this.getDatabaseType());
    }

    @Override
    public ASTNode visitDropUser(PostgreSQLStatementParser.DropUserContext ctx) {
        return new DropUserStatement(this.getDatabaseType(), Collections.emptyList());
    }

    @Override
    public ASTNode visitAlterUser(PostgreSQLStatementParser.AlterUserContext ctx) {
        return new AlterUserStatement(this.getDatabaseType(), null);
    }

    @Override
    public ASTNode visitCreateRole(PostgreSQLStatementParser.CreateRoleContext ctx) {
        return new CreateRoleStatement(this.getDatabaseType());
    }

    @Override
    public ASTNode visitAlterRole(PostgreSQLStatementParser.AlterRoleContext ctx) {
        return new AlterRoleStatement(this.getDatabaseType());
    }

    @Override
    public ASTNode visitDropRole(PostgreSQLStatementParser.DropRoleContext ctx) {
        return new DropRoleStatement(this.getDatabaseType());
    }

    @Override
    public ASTNode visitReassignOwned(PostgreSQLStatementParser.ReassignOwnedContext ctx) {
        return new PostgreSQLReassignOwnedStatement(this.getDatabaseType());
    }

    @Override
    public ASTNode visitCreateGroup(PostgreSQLStatementParser.CreateGroupContext ctx) {
        return new PostgreSQLCreateGroupStatement(this.getDatabaseType());
    }
}

