/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sql.parser.engine.postgresql.visitor.statement.type;

import java.util.Collections;
import java.util.LinkedList;
import org.antlr.v4.runtime.tree.ParseTree;
import org.apache.shardingsphere.database.connector.core.type.DatabaseType;
import org.apache.shardingsphere.sql.parser.api.ASTNode;
import org.apache.shardingsphere.sql.parser.api.visitor.statement.type.DALStatementVisitor;
import org.apache.shardingsphere.sql.parser.autogen.PostgreSQLStatementParser;
import org.apache.shardingsphere.sql.parser.engine.postgresql.visitor.statement.PostgreSQLStatementVisitor;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dal.VariableAssignSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dal.VariableSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.generic.table.SimpleTableSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.generic.table.TableNameSegment;
import org.apache.shardingsphere.sql.parser.statement.core.statement.SQLStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.type.dal.AnalyzeTableStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.type.dal.EmptyStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.type.dal.ExplainStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.type.dal.SetStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.type.dal.ShowStatement;
import org.apache.shardingsphere.sql.parser.statement.core.value.collection.CollectionValue;
import org.apache.shardingsphere.sql.parser.statement.core.value.identifier.IdentifierValue;
import org.apache.shardingsphere.sql.parser.statement.postgresql.dal.PostgreSQLCheckpointStatement;
import org.apache.shardingsphere.sql.parser.statement.postgresql.dal.PostgreSQLLoadStatement;
import org.apache.shardingsphere.sql.parser.statement.postgresql.dal.PostgreSQLResetParameterStatement;
import org.apache.shardingsphere.sql.parser.statement.postgresql.dal.PostgreSQLVacuumStatement;

public final class PostgreSQLDALStatementVisitor
extends PostgreSQLStatementVisitor
implements DALStatementVisitor {
    public PostgreSQLDALStatementVisitor(DatabaseType databaseType) {
        super(databaseType);
    }

    @Override
    public ASTNode visitShow(PostgreSQLStatementParser.ShowContext ctx) {
        if (null != ctx.varName()) {
            return new ShowStatement(this.getDatabaseType(), ctx.varName().getText());
        }
        if (null != ctx.ZONE()) {
            return new ShowStatement(this.getDatabaseType(), "timezone");
        }
        if (null != ctx.ISOLATION()) {
            return new ShowStatement(this.getDatabaseType(), "transaction_isolation");
        }
        if (null != ctx.AUTHORIZATION()) {
            return new ShowStatement(this.getDatabaseType(), "session_authorization");
        }
        return new ShowStatement(this.getDatabaseType(), "ALL");
    }

    @Override
    public ASTNode visitSet(PostgreSQLStatementParser.SetContext ctx) {
        LinkedList<VariableAssignSegment> variableAssigns = new LinkedList<VariableAssignSegment>();
        if (null != ctx.configurationParameterClause()) {
            VariableAssignSegment variableAssignSegment = (VariableAssignSegment)this.visit((ParseTree)ctx.configurationParameterClause());
            if (null != ctx.runtimeScope()) {
                variableAssignSegment.getVariable().setScope(ctx.runtimeScope().getText());
            }
            variableAssigns.add(variableAssignSegment);
        }
        if (null != ctx.encoding()) {
            VariableSegment variable = new VariableSegment(ctx.NAMES().getSymbol().getStartIndex(), ctx.NAMES().getSymbol().getStopIndex(), "client_encoding");
            VariableAssignSegment variableAssign = new VariableAssignSegment(ctx.encoding().start.getStartIndex(), ctx.encoding().stop.getStopIndex(), variable, ctx.encoding().getText());
            variableAssigns.add(variableAssign);
        }
        return new SetStatement(this.getDatabaseType(), variableAssigns);
    }

    @Override
    public ASTNode visitConfigurationParameterClause(PostgreSQLStatementParser.ConfigurationParameterClauseContext ctx) {
        return new VariableAssignSegment(ctx.start.getStartIndex(), ctx.stop.getStopIndex(), new VariableSegment(ctx.varName().start.getStartIndex(), ctx.varName().stop.getStopIndex(), ctx.varName().getText()), this.getAssignValue(ctx));
    }

    private String getAssignValue(PostgreSQLStatementParser.ConfigurationParameterClauseContext ctx) {
        if (null != ctx.varList()) {
            return ctx.varList().getText();
        }
        if (null != ctx.DEFAULT()) {
            return ctx.DEFAULT().getText();
        }
        return null;
    }

    @Override
    public ASTNode visitResetParameter(PostgreSQLStatementParser.ResetParameterContext ctx) {
        return new PostgreSQLResetParameterStatement(this.getDatabaseType(), null == ctx.ALL() ? ctx.identifier().getText() : "ALL");
    }

    @Override
    public ASTNode visitAnalyzeTable(PostgreSQLStatementParser.AnalyzeTableContext ctx) {
        return new AnalyzeTableStatement(this.getDatabaseType(), null == ctx.vacuumRelationList() ? Collections.emptyList() : ((CollectionValue)this.visit((ParseTree)ctx.vacuumRelationList())).getValue());
    }

    @Override
    public ASTNode visitVacuumRelationList(PostgreSQLStatementParser.VacuumRelationListContext ctx) {
        CollectionValue result = new CollectionValue();
        for (PostgreSQLStatementParser.VacuumRelationContext each : ctx.vacuumRelation()) {
            PostgreSQLStatementParser.ColIdContext colId = each.qualifiedName().colId();
            TableNameSegment tableName = new TableNameSegment(colId.start.getStartIndex(), colId.stop.getStopIndex(), new IdentifierValue(colId.getText()));
            result.getValue().add(new SimpleTableSegment(tableName));
        }
        return result;
    }

    @Override
    public ASTNode visitLoad(PostgreSQLStatementParser.LoadContext ctx) {
        return new PostgreSQLLoadStatement(this.getDatabaseType());
    }

    @Override
    public ASTNode visitVacuum(PostgreSQLStatementParser.VacuumContext ctx) {
        return new PostgreSQLVacuumStatement(this.getDatabaseType());
    }

    @Override
    public ASTNode visitExplain(PostgreSQLStatementParser.ExplainContext ctx) {
        return new ExplainStatement(this.getDatabaseType(), (SQLStatement)this.visit((ParseTree)ctx.explainableStmt()));
    }

    @Override
    public ASTNode visitExplainableStmt(PostgreSQLStatementParser.ExplainableStmtContext ctx) {
        if (null != ctx.select()) {
            return (ASTNode)this.visit((ParseTree)ctx.select());
        }
        if (null != ctx.insert()) {
            return (ASTNode)this.visit((ParseTree)ctx.insert());
        }
        if (null != ctx.update()) {
            return (ASTNode)this.visit((ParseTree)ctx.update());
        }
        if (null != ctx.delete()) {
            return (ASTNode)this.visit((ParseTree)ctx.delete());
        }
        if (null != ctx.declare()) {
            return (ASTNode)this.visit((ParseTree)ctx.declare());
        }
        if (null != ctx.executeStmt()) {
            return (ASTNode)this.visit((ParseTree)ctx.executeStmt());
        }
        if (null != ctx.createMaterializedView()) {
            return (ASTNode)this.visit((ParseTree)ctx.createMaterializedView());
        }
        return (ASTNode)this.visit((ParseTree)ctx.refreshMatViewStmt());
    }

    @Override
    public ASTNode visitCheckpoint(PostgreSQLStatementParser.CheckpointContext ctx) {
        return new PostgreSQLCheckpointStatement(this.getDatabaseType());
    }

    @Override
    public ASTNode visitEmptyStatement(PostgreSQLStatementParser.EmptyStatementContext ctx) {
        return new EmptyStatement(this.getDatabaseType());
    }
}

