/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.mode.manager.standalone.persist.service;

import java.sql.SQLException;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.stream.Collectors;
import org.apache.shardingsphere.infra.config.rule.RuleConfiguration;
import org.apache.shardingsphere.infra.datasource.pool.props.domain.DataSourcePoolProperties;
import org.apache.shardingsphere.infra.exception.external.sql.type.wrapper.SQLWrapperException;
import org.apache.shardingsphere.infra.metadata.ShardingSphereMetaData;
import org.apache.shardingsphere.infra.metadata.database.ShardingSphereDatabase;
import org.apache.shardingsphere.infra.metadata.database.rule.RuleMetaData;
import org.apache.shardingsphere.infra.metadata.database.schema.model.ShardingSphereTable;
import org.apache.shardingsphere.infra.metadata.database.schema.model.ShardingSphereView;
import org.apache.shardingsphere.infra.rule.scope.GlobalRule;
import org.apache.shardingsphere.infra.spi.type.ordered.cache.OrderedServicesCache;
import org.apache.shardingsphere.mode.event.DataChangedEvent;
import org.apache.shardingsphere.mode.metadata.MetaDataContexts;
import org.apache.shardingsphere.mode.metadata.changed.RuleItemChangedNodePathBuilder;
import org.apache.shardingsphere.mode.metadata.manager.ActiveVersionChecker;
import org.apache.shardingsphere.mode.metadata.manager.MetaDataContextManager;
import org.apache.shardingsphere.mode.metadata.persist.MetaDataPersistFacade;
import org.apache.shardingsphere.mode.metadata.refresher.util.TableRefreshUtils;
import org.apache.shardingsphere.mode.node.path.NodePath;
import org.apache.shardingsphere.mode.node.path.engine.generator.NodePathGenerator;
import org.apache.shardingsphere.mode.node.path.type.database.metadata.rule.DatabaseRuleNodePath;
import org.apache.shardingsphere.mode.node.path.version.MetaDataVersion;
import org.apache.shardingsphere.mode.node.path.version.VersionNodePath;
import org.apache.shardingsphere.mode.persist.service.MetaDataManagerPersistService;
import org.apache.shardingsphere.single.config.SingleRuleConfiguration;
import org.apache.shardingsphere.single.rule.SingleRule;

public final class StandaloneMetaDataManagerPersistService
implements MetaDataManagerPersistService {
    private final MetaDataContextManager metaDataContextManager;
    private final MetaDataPersistFacade metaDataPersistFacade;

    public StandaloneMetaDataManagerPersistService(MetaDataContextManager metaDataContextManager) {
        this.metaDataContextManager = metaDataContextManager;
        this.metaDataPersistFacade = metaDataContextManager.getMetaDataPersistFacade();
    }

    public void createDatabase(String databaseName) {
        this.metaDataPersistFacade.getDatabaseMetaDataFacade().getDatabase().add(databaseName);
        this.metaDataContextManager.getDatabaseMetaDataManager().addDatabase(databaseName);
        this.metaDataPersistFacade.getDatabaseMetaDataFacade().persistCreatedDatabaseSchemas(this.metaDataContextManager.getMetaDataContexts().getMetaData().getDatabase(databaseName));
        this.clearServicesCache();
    }

    public void dropDatabase(ShardingSphereDatabase database) {
        this.metaDataPersistFacade.getDatabaseMetaDataFacade().getDatabase().drop(database.getName());
        this.metaDataContextManager.getDatabaseMetaDataManager().dropDatabase(database.getName());
        this.clearServicesCache();
    }

    public void createSchema(ShardingSphereDatabase database, String schemaName) {
        this.metaDataPersistFacade.getDatabaseMetaDataFacade().getSchema().add(database.getName(), schemaName);
        this.metaDataContextManager.getDatabaseMetaDataManager().addSchema(database.getName(), schemaName);
    }

    public void renameSchema(ShardingSphereDatabase database, String schemaName, String renameSchemaName) {
        this.metaDataPersistFacade.getDatabaseMetaDataFacade().renameSchema(this.metaDataContextManager.getMetaDataContexts().getMetaData(), database, schemaName, renameSchemaName);
        this.metaDataContextManager.getDatabaseMetaDataManager().renameSchema(database.getName(), schemaName, renameSchemaName);
    }

    public void dropSchema(ShardingSphereDatabase database, Collection<String> schemaNames) {
        schemaNames.forEach(each -> this.dropSchema(database.getName(), (String)each));
    }

    private void dropSchema(String databaseName, String schemaName) {
        this.metaDataPersistFacade.getDatabaseMetaDataFacade().getSchema().drop(databaseName, schemaName);
        this.metaDataContextManager.getDatabaseMetaDataManager().dropSchema(databaseName, schemaName);
    }

    public void createTable(ShardingSphereDatabase database, String schemaName, ShardingSphereTable table) {
        this.metaDataPersistFacade.getDatabaseMetaDataFacade().getTable().persist(database.getName(), schemaName, Collections.singleton(table));
        this.metaDataContextManager.getDatabaseMetaDataManager().alterTable(database.getName(), schemaName, table);
        if (TableRefreshUtils.isSingleTable((String)table.getName(), (ShardingSphereDatabase)database) && TableRefreshUtils.isNeedRefresh((RuleMetaData)database.getRuleMetaData(), (String)schemaName, (String)table.getName())) {
            this.alterSingleRuleConfiguration(database, database.getRuleMetaData());
        }
    }

    public void dropTables(ShardingSphereDatabase database, String schemaName, Collection<String> tableNames) {
        boolean isNeedRefresh = TableRefreshUtils.isNeedRefresh((RuleMetaData)database.getRuleMetaData(), (String)schemaName, tableNames);
        tableNames.forEach(each -> {
            this.metaDataPersistFacade.getDatabaseMetaDataFacade().getTable().drop(database.getName(), schemaName, each);
            this.metaDataContextManager.getDatabaseMetaDataManager().dropTable(database.getName(), schemaName, each);
        });
        if (isNeedRefresh && tableNames.stream().anyMatch(each -> TableRefreshUtils.isSingleTable((String)each, (ShardingSphereDatabase)database))) {
            this.alterSingleRuleConfiguration(database, database.getRuleMetaData());
        }
    }

    public void alterTables(ShardingSphereDatabase database, String schemaName, Collection<ShardingSphereTable> alteredTables) {
        this.metaDataPersistFacade.getDatabaseMetaDataFacade().getTable().persist(database.getName(), schemaName, alteredTables);
        alteredTables.forEach(each -> this.metaDataContextManager.getDatabaseMetaDataManager().alterTable(database.getName(), schemaName, each));
        this.refreshGlobalRules(GlobalRule.GlobalRuleChangedType.SCHEMA_CHANGED);
    }

    public void alterViews(ShardingSphereDatabase database, String schemaName, Collection<ShardingSphereView> alteredViews) {
        this.metaDataPersistFacade.getDatabaseMetaDataFacade().getView().persist(database.getName(), schemaName, alteredViews);
        alteredViews.forEach(each -> this.metaDataContextManager.getDatabaseMetaDataManager().alterView(database.getName(), schemaName, each));
        this.refreshGlobalRules(GlobalRule.GlobalRuleChangedType.SCHEMA_CHANGED);
    }

    public void dropViews(ShardingSphereDatabase database, String schemaName, Collection<String> droppedViews) {
        droppedViews.forEach(each -> {
            this.metaDataPersistFacade.getDatabaseMetaDataFacade().getView().drop(database.getName(), schemaName, each);
            this.metaDataContextManager.getDatabaseMetaDataManager().dropView(database.getName(), schemaName, each);
        });
        this.refreshGlobalRules(GlobalRule.GlobalRuleChangedType.SCHEMA_CHANGED);
    }

    public void registerStorageUnits(String databaseName, Map<String, DataSourcePoolProperties> toBeRegisteredProps) {
        MetaDataContexts originalMetaDataContexts = new MetaDataContexts(this.metaDataContextManager.getMetaDataContexts().getMetaData(), this.metaDataContextManager.getMetaDataContexts().getStatistics());
        this.metaDataPersistFacade.getDataSourceUnitService().persist(databaseName, toBeRegisteredProps);
        this.afterStorageUnitsRegistered(databaseName, originalMetaDataContexts, toBeRegisteredProps);
        this.clearServicesCache();
    }

    private void afterStorageUnitsRegistered(String databaseName, MetaDataContexts originalMetaDataContexts, Map<String, DataSourcePoolProperties> toBeRegisteredProps) {
        this.metaDataContextManager.getStorageUnitManager().register(databaseName, toBeRegisteredProps);
        this.metaDataPersistFacade.getDatabaseMetaDataFacade().persistReloadDatabase(databaseName, this.metaDataContextManager.getMetaDataContexts().getMetaData().getDatabase(databaseName), originalMetaDataContexts.getMetaData().getDatabase(databaseName));
        this.refreshGlobalRules(GlobalRule.GlobalRuleChangedType.DATABASE_CHANGED);
    }

    public void alterStorageUnits(ShardingSphereDatabase database, Map<String, DataSourcePoolProperties> toBeUpdatedProps) {
        MetaDataContexts originalMetaDataContexts = new MetaDataContexts(this.metaDataContextManager.getMetaDataContexts().getMetaData(), this.metaDataContextManager.getMetaDataContexts().getStatistics());
        this.metaDataPersistFacade.getDataSourceUnitService().persist(database.getName(), toBeUpdatedProps);
        this.afterStorageUnitsAltered(database.getName(), originalMetaDataContexts, toBeUpdatedProps);
        this.clearServicesCache();
    }

    private void afterStorageUnitsAltered(String databaseName, MetaDataContexts originalMetaDataContexts, Map<String, DataSourcePoolProperties> toBeRegisteredProps) {
        this.metaDataContextManager.getStorageUnitManager().alter(databaseName, toBeRegisteredProps);
        this.metaDataPersistFacade.getDatabaseMetaDataFacade().persistReloadDatabase(databaseName, this.metaDataContextManager.getMetaDataContexts().getMetaData().getDatabase(databaseName), originalMetaDataContexts.getMetaData().getDatabase(databaseName));
        this.refreshGlobalRules(GlobalRule.GlobalRuleChangedType.DATABASE_CHANGED);
    }

    public void unregisterStorageUnits(ShardingSphereDatabase database, Collection<String> toBeDroppedStorageUnitNames) {
        for (String each : this.getToBeDroppedResourceNames(database.getName(), toBeDroppedStorageUnitNames)) {
            this.metaDataPersistFacade.getDataSourceUnitService().delete(database.getName(), each);
            this.metaDataContextManager.getStorageUnitManager().unregister(database.getName(), each);
            MetaDataContexts reloadMetaDataContexts = this.metaDataContextManager.getMetaDataContexts();
            this.metaDataPersistFacade.getDatabaseMetaDataFacade().unregisterStorageUnits(database.getName(), reloadMetaDataContexts);
        }
        this.clearServicesCache();
    }

    private Collection<String> getToBeDroppedResourceNames(String databaseName, Collection<String> toBeDroppedResourceNames) {
        Map propsMap = this.metaDataPersistFacade.getDataSourceUnitService().load(databaseName);
        return toBeDroppedResourceNames.stream().filter(propsMap::containsKey).collect(Collectors.toList());
    }

    public void alterSingleRuleConfiguration(ShardingSphereDatabase database, RuleMetaData ruleMetaData) {
        SingleRuleConfiguration singleRuleConfig = ((SingleRule)ruleMetaData.getSingleRule(SingleRule.class)).getConfiguration();
        this.metaDataPersistFacade.getDatabaseRuleService().persist(database.getName(), Collections.singleton(singleRuleConfig));
        try {
            this.metaDataContextManager.getDatabaseRuleConfigurationManager().refresh(database.getName(), (RuleConfiguration)singleRuleConfig, true);
        }
        catch (SQLException ex) {
            throw new SQLWrapperException(ex);
        }
        this.clearServicesCache();
    }

    public void alterRuleConfiguration(ShardingSphereDatabase database, RuleConfiguration toBeAlteredRuleConfig) {
        if (null == toBeAlteredRuleConfig) {
            return;
        }
        Collection<String> needReloadTables = this.getNeedReloadTables(database, toBeAlteredRuleConfig);
        Collection metaDataVersions = this.metaDataPersistFacade.getDatabaseRuleService().persist(database.getName(), Collections.singleton(toBeAlteredRuleConfig));
        this.alterRuleItem(database.getName(), metaDataVersions);
        this.persistAndAlterSchemaTables(database, needReloadTables);
        this.clearServicesCache();
    }

    private void alterRuleItem(String databaseName, Collection<MetaDataVersion> metaDataVersions) {
        RuleItemChangedNodePathBuilder ruleItemChangedNodePathBuilder = new RuleItemChangedNodePathBuilder();
        ActiveVersionChecker activeVersionChecker = new ActiveVersionChecker(this.metaDataPersistFacade.getRepository());
        for (MetaDataVersion each : metaDataVersions) {
            Optional databaseRuleNodePath = ruleItemChangedNodePathBuilder.build(databaseName, new VersionNodePath(each.getNodePath()).getActiveVersionPath(), DataChangedEvent.Type.UPDATED);
            if (!databaseRuleNodePath.isPresent() || !activeVersionChecker.checkSame(new VersionNodePath((NodePath)databaseRuleNodePath.get()), each.getActiveVersion())) continue;
            this.metaDataContextManager.getDatabaseRuleItemManager().alter((DatabaseRuleNodePath)databaseRuleNodePath.get());
        }
    }

    public void removeRuleConfigurationItem(ShardingSphereDatabase database, RuleConfiguration toBeRemovedRuleItemConfig) {
        if (null == toBeRemovedRuleItemConfig) {
            return;
        }
        Collection<String> needReloadTables = this.getNeedReloadTables(database, toBeRemovedRuleItemConfig);
        Collection metaDataVersions = this.metaDataPersistFacade.getDatabaseRuleService().delete(database.getName(), Collections.singleton(toBeRemovedRuleItemConfig));
        this.removeRuleItem(database.getName(), metaDataVersions);
        this.persistAndAlterSchemaTables(database, needReloadTables);
        this.clearServicesCache();
    }

    private void removeRuleItem(String databaseName, Collection<MetaDataVersion> metaDataVersions) {
        RuleItemChangedNodePathBuilder ruleItemChangedNodePathBuilder = new RuleItemChangedNodePathBuilder();
        for (MetaDataVersion each : metaDataVersions) {
            ruleItemChangedNodePathBuilder.build(databaseName, NodePathGenerator.toPath((NodePath)each.getNodePath()), DataChangedEvent.Type.DELETED).ifPresent(optional -> this.metaDataContextManager.getDatabaseRuleItemManager().drop(optional));
        }
    }

    private Collection<String> getNeedReloadTables(ShardingSphereDatabase originalDatabase, RuleConfiguration toBeAlteredRuleConfig) {
        if (toBeAlteredRuleConfig instanceof SingleRuleConfiguration) {
            Collection originalSingleTables = ((SingleRule)originalDatabase.getRuleMetaData().getSingleRule(SingleRule.class)).getConfiguration().getLogicTableNames();
            return toBeAlteredRuleConfig.getLogicTableNames().stream().filter(each -> !originalSingleTables.contains(each)).collect(Collectors.toList());
        }
        return toBeAlteredRuleConfig.getLogicTableNames();
    }

    private void alterSchemaTables(ShardingSphereDatabase database, Map<String, Collection<ShardingSphereTable>> schemaAndTablesMap) {
        for (Map.Entry<String, Collection<ShardingSphereTable>> entry : schemaAndTablesMap.entrySet()) {
            for (ShardingSphereTable each : entry.getValue()) {
                this.metaDataContextManager.getDatabaseMetaDataManager().alterTable(database.getName(), entry.getKey(), each);
            }
        }
    }

    public void removeRuleConfiguration(ShardingSphereDatabase database, RuleConfiguration toBeRemovedRuleConfig, String ruleType) {
        Collection<String> needReloadTables = this.getNeedReloadTables(database, toBeRemovedRuleConfig);
        this.metaDataPersistFacade.getDatabaseRuleService().delete(database.getName(), ruleType);
        this.metaDataContextManager.getDatabaseRuleItemManager().drop(new DatabaseRuleNodePath(database.getName(), ruleType, null));
        this.persistAndAlterSchemaTables(database, needReloadTables);
        this.clearServicesCache();
    }

    public void alterGlobalRuleConfiguration(RuleConfiguration toBeAlteredRuleConfig) {
        this.metaDataPersistFacade.getGlobalRuleService().persist(Collections.singleton(toBeAlteredRuleConfig));
        this.metaDataContextManager.getGlobalConfigurationManager().alterGlobalRuleConfiguration(toBeAlteredRuleConfig);
        this.clearServicesCache();
    }

    public void alterProperties(Properties props) {
        this.metaDataPersistFacade.getPropsService().persist(props);
        this.metaDataContextManager.getGlobalConfigurationManager().alterProperties(props);
        this.clearServicesCache();
    }

    private void clearServicesCache() {
        OrderedServicesCache.clearCache();
    }

    private void refreshGlobalRules(GlobalRule.GlobalRuleChangedType changedType) {
        ShardingSphereMetaData metaData = this.metaDataContextManager.getMetaDataContexts().getMetaData();
        metaData.getGlobalRuleMetaData().getRules().forEach(each -> ((GlobalRule)each).refresh(metaData.getAllDatabases(), changedType));
    }

    private void persistAndAlterSchemaTables(ShardingSphereDatabase database, Collection<String> needReloadTables) {
        Map schemaAndTablesMap = this.metaDataPersistFacade.getDatabaseMetaDataFacade().persistAlteredTables(database.getName(), this.metaDataContextManager.getMetaDataContexts(), needReloadTables);
        this.alterSchemaTables(database, schemaAndTablesMap);
    }
}

