/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.mode.metadata.refresher.util;

import com.google.common.base.Joiner;
import java.util.Collection;
import java.util.LinkedList;
import java.util.Optional;
import lombok.Generated;
import org.apache.shardingsphere.database.connector.core.metadata.database.enums.QuoteCharacter;
import org.apache.shardingsphere.database.connector.core.type.DatabaseType;
import org.apache.shardingsphere.database.connector.core.type.DatabaseTypeRegistry;
import org.apache.shardingsphere.infra.config.rule.RuleConfiguration;
import org.apache.shardingsphere.infra.datanode.DataNode;
import org.apache.shardingsphere.infra.metadata.database.ShardingSphereDatabase;
import org.apache.shardingsphere.infra.metadata.database.rule.RuleMetaData;
import org.apache.shardingsphere.infra.rule.ShardingSphereRule;
import org.apache.shardingsphere.infra.rule.attribute.datanode.MutableDataNodeRuleAttribute;
import org.apache.shardingsphere.infra.rule.attribute.table.TableMapperRuleAttribute;
import org.apache.shardingsphere.single.config.SingleRuleConfiguration;
import org.apache.shardingsphere.sql.parser.statement.core.value.identifier.IdentifierValue;

public final class TableRefreshUtils {
    public static String getTableName(IdentifierValue tableIdentifierValue, DatabaseType databaseType) {
        return QuoteCharacter.NONE == tableIdentifierValue.getQuoteCharacter() ? new DatabaseTypeRegistry(databaseType).formatIdentifierPattern(tableIdentifierValue.getValue()) : tableIdentifierValue.getValue();
    }

    public static boolean isSingleTable(String tableName, ShardingSphereDatabase database) {
        return database.getRuleMetaData().getAttributes(TableMapperRuleAttribute.class).stream().noneMatch(each -> each.getDistributedTableNames().contains(tableName));
    }

    public static boolean isNeedRefresh(RuleMetaData ruleMetaData, String schemaName, Collection<String> tableNames) {
        return tableNames.stream().anyMatch(each -> TableRefreshUtils.isNeedRefresh(ruleMetaData, schemaName, each));
    }

    public static boolean isNeedRefresh(RuleMetaData ruleMetaData, String schemaName, String tableName) {
        LinkedList rules = new LinkedList();
        for (ShardingSphereRule each : ruleMetaData.getRules()) {
            each.getAttributes().findAttribute(MutableDataNodeRuleAttribute.class).ifPresent(optional -> rules.add(each));
        }
        if (rules.isEmpty()) {
            return false;
        }
        ShardingSphereRule rule = (ShardingSphereRule)rules.iterator().next();
        RuleConfiguration ruleConfig = rule.getConfiguration();
        if (!(ruleConfig instanceof SingleRuleConfiguration)) {
            return false;
        }
        Collection tablesConfig = ((SingleRuleConfiguration)ruleConfig).getTables();
        if (tablesConfig.contains("*.*") || tablesConfig.contains("*.*.*")) {
            return false;
        }
        Optional dataNode = ((MutableDataNodeRuleAttribute)rule.getAttributes().getAttribute(MutableDataNodeRuleAttribute.class)).findTableDataNode(schemaName, tableName);
        if (!dataNode.isPresent()) {
            return false;
        }
        DataNode actualNode = (DataNode)dataNode.get();
        return !tablesConfig.contains(TableRefreshUtils.joinDataNodeSegments(actualNode.getDataSourceName(), "*")) && !tablesConfig.contains(TableRefreshUtils.joinDataNodeSegments(actualNode.getDataSourceName(), "*", "*")) && !tablesConfig.contains(TableRefreshUtils.joinDataNodeSegments(actualNode.getDataSourceName(), actualNode.getSchemaName(), "*"));
    }

    private static String joinDataNodeSegments(String ... segments) {
        return Joiner.on((String)".").join((Object[])segments);
    }

    @Generated
    private TableRefreshUtils() {
    }
}

