/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.mode.metadata.refresher.pushdown.type.view;

import java.util.LinkedList;
import org.apache.shardingsphere.database.connector.core.type.DatabaseType;
import org.apache.shardingsphere.infra.config.props.ConfigurationProperties;
import org.apache.shardingsphere.infra.metadata.database.ShardingSphereDatabase;
import org.apache.shardingsphere.mode.metadata.refresher.pushdown.PushDownMetaDataRefresher;
import org.apache.shardingsphere.mode.persist.service.MetaDataManagerPersistService;
import org.apache.shardingsphere.sql.parser.statement.core.segment.generic.table.SimpleTableSegment;
import org.apache.shardingsphere.sql.parser.statement.core.statement.type.ddl.view.DropViewStatement;

public final class DropViewPushDownMetaDataRefresher
implements PushDownMetaDataRefresher<DropViewStatement> {
    @Override
    public void refresh(MetaDataManagerPersistService metaDataManagerPersistService, ShardingSphereDatabase database, String logicDataSourceName, String schemaName, DatabaseType databaseType, DropViewStatement sqlStatement, ConfigurationProperties props) {
        LinkedList<String> droppedTables = new LinkedList<String>();
        LinkedList<String> droppedViews = new LinkedList<String>();
        for (SimpleTableSegment each : sqlStatement.getViews()) {
            String viewName = each.getTableName().getIdentifier().getValue();
            droppedTables.add(viewName);
            droppedViews.add(viewName);
        }
        metaDataManagerPersistService.dropTables(database, schemaName, droppedTables);
        metaDataManagerPersistService.dropViews(database, schemaName, droppedViews);
    }

    @Override
    public Class<DropViewStatement> getType() {
        return DropViewStatement.class;
    }
}

