/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.mode.metadata.refresher.pushdown.type.schema;

import java.util.Optional;
import org.apache.shardingsphere.database.connector.core.type.DatabaseType;
import org.apache.shardingsphere.infra.config.props.ConfigurationProperties;
import org.apache.shardingsphere.infra.metadata.database.ShardingSphereDatabase;
import org.apache.shardingsphere.mode.metadata.refresher.pushdown.PushDownMetaDataRefresher;
import org.apache.shardingsphere.mode.persist.service.MetaDataManagerPersistService;
import org.apache.shardingsphere.sql.parser.statement.core.statement.type.ddl.schema.CreateSchemaStatement;
import org.apache.shardingsphere.sql.parser.statement.core.value.identifier.IdentifierValue;

public final class CreateSchemaPushDownMetaDataRefresher
implements PushDownMetaDataRefresher<CreateSchemaStatement> {
    @Override
    public void refresh(MetaDataManagerPersistService metaDataManagerPersistService, ShardingSphereDatabase database, String logicDataSourceName, String schemaName, DatabaseType databaseType, CreateSchemaStatement sqlStatement, ConfigurationProperties props) {
        CreateSchemaPushDownMetaDataRefresher.getSchemaName(sqlStatement).ifPresent(optional -> metaDataManagerPersistService.createSchema(database, optional.getValue().toLowerCase()));
    }

    private static Optional<IdentifierValue> getSchemaName(CreateSchemaStatement sqlStatement) {
        return sqlStatement.getSchemaName().isPresent() ? sqlStatement.getSchemaName() : sqlStatement.getUsername();
    }

    @Override
    public Class<CreateSchemaStatement> getType() {
        return CreateSchemaStatement.class;
    }
}

