/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.mode.metadata.refresher.pushdown.type.schema;

import java.util.Optional;
import org.apache.shardingsphere.database.connector.core.type.DatabaseType;
import org.apache.shardingsphere.infra.config.props.ConfigurationProperties;
import org.apache.shardingsphere.infra.metadata.database.ShardingSphereDatabase;
import org.apache.shardingsphere.mode.metadata.refresher.pushdown.PushDownMetaDataRefresher;
import org.apache.shardingsphere.mode.persist.service.MetaDataManagerPersistService;
import org.apache.shardingsphere.sql.parser.statement.core.statement.type.ddl.schema.AlterSchemaStatement;

public final class AlterSchemaPushDownMetaDataRefresher
implements PushDownMetaDataRefresher<AlterSchemaStatement> {
    @Override
    public void refresh(MetaDataManagerPersistService metaDataManagerPersistService, ShardingSphereDatabase database, String logicDataSourceName, String schemaName, DatabaseType databaseType, AlterSchemaStatement sqlStatement, ConfigurationProperties props) {
        Optional<String> renameSchemaName = sqlStatement.getRenameSchema().map(optional -> optional.getValue().toLowerCase());
        if (!renameSchemaName.isPresent()) {
            return;
        }
        metaDataManagerPersistService.renameSchema(database, sqlStatement.getSchemaName().getValue().toLowerCase(), renameSchemaName.get());
    }

    @Override
    public Class<AlterSchemaStatement> getType() {
        return AlterSchemaStatement.class;
    }
}

