/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.mode.metadata.refresher.pushdown.type.index;

import java.util.Collections;
import java.util.LinkedList;
import java.util.Optional;
import org.apache.shardingsphere.database.connector.core.type.DatabaseType;
import org.apache.shardingsphere.infra.config.props.ConfigurationProperties;
import org.apache.shardingsphere.infra.exception.ShardingSpherePreconditions;
import org.apache.shardingsphere.infra.exception.kernel.metadata.IndexNotFoundException;
import org.apache.shardingsphere.infra.exception.kernel.metadata.SchemaNotFoundException;
import org.apache.shardingsphere.infra.exception.kernel.metadata.TableNotFoundException;
import org.apache.shardingsphere.infra.metadata.database.ShardingSphereDatabase;
import org.apache.shardingsphere.infra.metadata.database.schema.model.ShardingSphereIndex;
import org.apache.shardingsphere.infra.metadata.database.schema.model.ShardingSphereSchema;
import org.apache.shardingsphere.infra.metadata.database.schema.model.ShardingSphereTable;
import org.apache.shardingsphere.mode.metadata.refresher.pushdown.PushDownMetaDataRefresher;
import org.apache.shardingsphere.mode.persist.service.MetaDataManagerPersistService;
import org.apache.shardingsphere.sql.parser.statement.core.segment.ddl.index.IndexSegment;
import org.apache.shardingsphere.sql.parser.statement.core.statement.type.ddl.index.AlterIndexStatement;

public final class AlterIndexPushDownMetaDataRefresher
implements PushDownMetaDataRefresher<AlterIndexStatement> {
    @Override
    public void refresh(MetaDataManagerPersistService metaDataManagerPersistService, ShardingSphereDatabase database, String logicDataSourceName, String schemaName, DatabaseType databaseType, AlterIndexStatement sqlStatement, ConfigurationProperties props) {
        Optional renameIndex = sqlStatement.getRenameIndex();
        if (!sqlStatement.getIndex().isPresent() || !renameIndex.isPresent()) {
            return;
        }
        String actualSchemaName = ((IndexSegment)sqlStatement.getIndex().get()).getOwner().map(optional -> optional.getIdentifier().getValue().toLowerCase()).orElse(schemaName);
        String indexName = ((IndexSegment)sqlStatement.getIndex().get()).getIndexName().getIdentifier().getValue();
        ShardingSpherePreconditions.checkState((boolean)database.containsSchema(actualSchemaName), () -> new SchemaNotFoundException(actualSchemaName));
        ShardingSphereSchema schema = database.getSchema(actualSchemaName);
        Optional<String> logicTableName = this.findLogicTableName(schema, indexName);
        ShardingSpherePreconditions.checkState((boolean)logicTableName.isPresent(), () -> new IndexNotFoundException(indexName, schemaName));
        ShardingSpherePreconditions.checkState((boolean)schema.containsTable(logicTableName.get()), () -> new TableNotFoundException((String)logicTableName.get()));
        ShardingSphereTable table = schema.getTable(logicTableName.get());
        ShardingSphereTable newTable = new ShardingSphereTable(table.getName(), table.getAllColumns(), table.getAllIndexes(), table.getAllConstraints(), table.getType());
        newTable.removeIndex(indexName);
        String renameIndexName = ((IndexSegment)renameIndex.get()).getIndexName().getIdentifier().getValue();
        newTable.putIndex(new ShardingSphereIndex(renameIndexName, new LinkedList(), false));
        metaDataManagerPersistService.alterTables(database, actualSchemaName, Collections.singleton(newTable));
    }

    private Optional<String> findLogicTableName(ShardingSphereSchema schema, String indexName) {
        return schema.getAllTables().stream().filter(each -> each.containsIndex(indexName)).findFirst().map(ShardingSphereTable::getName);
    }

    @Override
    public Class<AlterIndexStatement> getType() {
        return AlterIndexStatement.class;
    }
}

