/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.mode.metadata.refresher.federation.type;

import java.util.Collection;
import java.util.stream.Collectors;
import org.apache.shardingsphere.database.connector.core.type.DatabaseType;
import org.apache.shardingsphere.infra.metadata.database.ShardingSphereDatabase;
import org.apache.shardingsphere.mode.metadata.refresher.federation.FederationMetaDataRefresher;
import org.apache.shardingsphere.mode.persist.service.MetaDataManagerPersistService;
import org.apache.shardingsphere.sql.parser.statement.core.statement.type.ddl.view.DropViewStatement;

public final class DropViewFederationMetaDataRefresher
implements FederationMetaDataRefresher<DropViewStatement> {
    @Override
    public void refresh(MetaDataManagerPersistService metaDataManagerPersistService, DatabaseType databaseType, ShardingSphereDatabase database, String schemaName, DropViewStatement sqlStatement) {
        Collection droppedViews = sqlStatement.getViews().stream().map(each -> each.getTableName().getIdentifier().getValue()).collect(Collectors.toList());
        metaDataManagerPersistService.dropViews(database, schemaName, droppedViews);
    }

    @Override
    public Class<DropViewStatement> getType() {
        return DropViewStatement.class;
    }
}

