/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.mode.metadata.refresher.federation.type;

import java.util.Collections;
import org.apache.shardingsphere.database.connector.core.type.DatabaseType;
import org.apache.shardingsphere.infra.metadata.database.ShardingSphereDatabase;
import org.apache.shardingsphere.infra.metadata.database.schema.model.ShardingSphereView;
import org.apache.shardingsphere.mode.metadata.refresher.federation.FederationMetaDataRefresher;
import org.apache.shardingsphere.mode.metadata.refresher.util.TableRefreshUtils;
import org.apache.shardingsphere.mode.persist.service.MetaDataManagerPersistService;
import org.apache.shardingsphere.sql.parser.statement.core.statement.type.ddl.view.CreateViewStatement;

public final class CreateViewFederationMetaDataRefresher
implements FederationMetaDataRefresher<CreateViewStatement> {
    @Override
    public void refresh(MetaDataManagerPersistService metaDataManagerPersistService, DatabaseType databaseType, ShardingSphereDatabase database, String schemaName, CreateViewStatement sqlStatement) {
        String viewName = TableRefreshUtils.getTableName(sqlStatement.getView().getTableName().getIdentifier(), databaseType);
        metaDataManagerPersistService.alterViews(database, schemaName, Collections.singleton(new ShardingSphereView(viewName, sqlStatement.getViewDefinition())));
    }

    @Override
    public Class<CreateViewStatement> getType() {
        return CreateViewStatement.class;
    }
}

