/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.mode.metadata.refresher.federation;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Optional;
import org.apache.shardingsphere.infra.binder.context.statement.SQLStatementContext;
import org.apache.shardingsphere.infra.metadata.database.ShardingSphereDatabase;
import org.apache.shardingsphere.infra.spi.type.typed.TypedSPILoader;
import org.apache.shardingsphere.mode.metadata.refresher.federation.FederationMetaDataRefresher;
import org.apache.shardingsphere.mode.metadata.refresher.util.SchemaRefreshUtils;
import org.apache.shardingsphere.mode.persist.service.MetaDataManagerPersistService;
import org.apache.shardingsphere.sql.parser.statement.core.statement.type.ddl.view.AlterViewStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.type.ddl.view.CreateViewStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.type.ddl.view.DropViewStatement;

public final class FederationMetaDataRefreshEngine {
    private static final Collection<Class<?>> SUPPORTED_REFRESH_TYPES = new HashSet<Class>(Arrays.asList(CreateViewStatement.class, AlterViewStatement.class, DropViewStatement.class));
    private final SQLStatementContext sqlStatementContext;

    public FederationMetaDataRefreshEngine(SQLStatementContext sqlStatementContext) {
        this.sqlStatementContext = sqlStatementContext;
    }

    public boolean isNeedRefresh() {
        return SUPPORTED_REFRESH_TYPES.contains(this.sqlStatementContext.getSqlStatement().getClass());
    }

    public void refresh(MetaDataManagerPersistService metaDataManagerPersistService, ShardingSphereDatabase database) {
        Optional<FederationMetaDataRefresher> refresher = this.findFederationMetaDataRefresher();
        if (!refresher.isPresent()) {
            return;
        }
        refresher.get().refresh(metaDataManagerPersistService, this.sqlStatementContext.getSqlStatement().getDatabaseType(), database, SchemaRefreshUtils.getSchemaName(database, this.sqlStatementContext), this.sqlStatementContext.getSqlStatement());
    }

    private Optional<FederationMetaDataRefresher> findFederationMetaDataRefresher() {
        Optional refresher = TypedSPILoader.findService(FederationMetaDataRefresher.class, this.sqlStatementContext.getSqlStatement().getClass());
        return refresher.isPresent() ? refresher : TypedSPILoader.findService(FederationMetaDataRefresher.class, this.sqlStatementContext.getSqlStatement().getClass().getSuperclass());
    }
}

