/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.mode.metadata.persist.metadata.service;

import com.google.common.base.Strings;
import java.util.Collection;
import java.util.Optional;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.shardingsphere.infra.metadata.database.schema.model.ShardingSphereView;
import org.apache.shardingsphere.infra.util.yaml.YamlEngine;
import org.apache.shardingsphere.infra.yaml.schema.pojo.YamlShardingSphereView;
import org.apache.shardingsphere.infra.yaml.schema.swapper.YamlViewSwapper;
import org.apache.shardingsphere.mode.metadata.persist.version.VersionPersistService;
import org.apache.shardingsphere.mode.node.path.NodePath;
import org.apache.shardingsphere.mode.node.path.engine.generator.NodePathGenerator;
import org.apache.shardingsphere.mode.node.path.type.database.metadata.schema.ViewMetaDataNodePath;
import org.apache.shardingsphere.mode.node.path.version.VersionNodePath;
import org.apache.shardingsphere.mode.spi.repository.PersistRepository;

public final class ViewMetaDataPersistService {
    private final PersistRepository repository;
    private final VersionPersistService versionPersistService;
    private final YamlViewSwapper swapper = new YamlViewSwapper();

    public Collection<ShardingSphereView> load(String databaseName, String schemaName) {
        return this.repository.getChildrenKeys(NodePathGenerator.toPath((NodePath)new ViewMetaDataNodePath(databaseName, schemaName, null))).stream().map(each -> this.load(databaseName, schemaName, (String)each)).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toList());
    }

    public Optional<ShardingSphereView> load(String databaseName, String schemaName, String viewName) {
        VersionNodePath versionNodePath = new VersionNodePath((NodePath)new ViewMetaDataNodePath(databaseName, schemaName, viewName));
        String activeVersion = this.repository.query(versionNodePath.getActiveVersionPath());
        if (Strings.isNullOrEmpty((String)activeVersion)) {
            return Optional.empty();
        }
        String view = this.repository.query(versionNodePath.getVersionPath(Integer.parseInt(activeVersion)));
        if (Strings.isNullOrEmpty((String)view)) {
            return Optional.empty();
        }
        return Optional.of(this.swapper.swapToObject((YamlShardingSphereView)YamlEngine.unmarshal((String)view, YamlShardingSphereView.class)));
    }

    public void persist(String databaseName, String schemaName, Collection<ShardingSphereView> views) {
        for (ShardingSphereView each : views) {
            String viewName = each.getName().toLowerCase();
            VersionNodePath versionNodePath = new VersionNodePath((NodePath)new ViewMetaDataNodePath(databaseName, schemaName, viewName));
            this.versionPersistService.persist(versionNodePath, YamlEngine.marshal((Object)this.swapper.swapToYamlConfiguration(each)));
        }
    }

    public void drop(String databaseName, String schemaName, String viewName) {
        this.repository.delete(NodePathGenerator.toPath((NodePath)new ViewMetaDataNodePath(databaseName, schemaName, viewName.toLowerCase())));
    }

    @Generated
    public ViewMetaDataPersistService(PersistRepository repository, VersionPersistService versionPersistService) {
        this.repository = repository;
        this.versionPersistService = versionPersistService;
    }
}

