/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.mode.metadata.persist.metadata.service;

import com.google.common.base.Strings;
import java.util.ArrayList;
import java.util.Collection;
import lombok.Generated;
import org.apache.shardingsphere.infra.metadata.database.schema.model.ShardingSphereTable;
import org.apache.shardingsphere.infra.metadata.statistics.TableStatistics;
import org.apache.shardingsphere.infra.util.yaml.YamlEngine;
import org.apache.shardingsphere.infra.yaml.data.pojo.YamlRowStatistics;
import org.apache.shardingsphere.infra.yaml.data.swapper.YamlRowStatisticsSwapper;
import org.apache.shardingsphere.mode.node.path.NodePath;
import org.apache.shardingsphere.mode.node.path.engine.generator.NodePathGenerator;
import org.apache.shardingsphere.mode.node.path.type.database.statistics.StatisticsDataNodePath;
import org.apache.shardingsphere.mode.node.path.type.database.statistics.StatisticsTableNodePath;
import org.apache.shardingsphere.mode.spi.repository.PersistRepository;

public final class TableRowDataPersistService {
    private final PersistRepository repository;

    public void persist(String databaseName, String schemaName, String tableName, Collection<YamlRowStatistics> rows) {
        if (rows.isEmpty()) {
            this.repository.persist(NodePathGenerator.toPath((NodePath)new StatisticsTableNodePath(databaseName, schemaName, tableName.toLowerCase())), "");
        } else {
            rows.forEach(each -> this.repository.persist(NodePathGenerator.toPath((NodePath)new StatisticsDataNodePath(databaseName, schemaName, tableName.toLowerCase(), each.getUniqueKey())), YamlEngine.marshal((Object)each)));
        }
    }

    public void delete(String databaseName, String schemaName, String tableName, Collection<YamlRowStatistics> rows) {
        rows.forEach(each -> this.repository.delete(NodePathGenerator.toPath((NodePath)new StatisticsDataNodePath(databaseName, schemaName, tableName.toLowerCase(), each.getUniqueKey()))));
    }

    public TableStatistics load(String databaseName, String schemaName, ShardingSphereTable table) {
        TableStatistics result = new TableStatistics(table.getName());
        YamlRowStatisticsSwapper swapper = new YamlRowStatisticsSwapper(new ArrayList(table.getAllColumns()));
        for (String each : this.repository.getChildrenKeys(NodePathGenerator.toPath((NodePath)new StatisticsTableNodePath(databaseName, schemaName, table.getName().toLowerCase())))) {
            String yamlRow = this.repository.query(NodePathGenerator.toPath((NodePath)new StatisticsDataNodePath(databaseName, schemaName, table.getName().toLowerCase(), each)));
            if (Strings.isNullOrEmpty((String)yamlRow)) continue;
            result.getRows().add(swapper.swapToObject((YamlRowStatistics)YamlEngine.unmarshal((String)yamlRow, YamlRowStatistics.class)));
        }
        return result;
    }

    @Generated
    public TableRowDataPersistService(PersistRepository repository) {
        this.repository = repository;
    }
}

