/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.mode.metadata.persist.metadata.service;

import com.google.common.base.Strings;
import java.util.Collection;
import java.util.Optional;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.shardingsphere.infra.metadata.database.schema.model.ShardingSphereTable;
import org.apache.shardingsphere.infra.util.yaml.YamlEngine;
import org.apache.shardingsphere.infra.yaml.schema.pojo.YamlShardingSphereTable;
import org.apache.shardingsphere.infra.yaml.schema.swapper.YamlTableSwapper;
import org.apache.shardingsphere.mode.metadata.persist.version.VersionPersistService;
import org.apache.shardingsphere.mode.node.path.NodePath;
import org.apache.shardingsphere.mode.node.path.engine.generator.NodePathGenerator;
import org.apache.shardingsphere.mode.node.path.type.database.metadata.schema.TableMetaDataNodePath;
import org.apache.shardingsphere.mode.node.path.version.VersionNodePath;
import org.apache.shardingsphere.mode.persist.service.TableMetaDataPersistService;
import org.apache.shardingsphere.mode.spi.repository.PersistRepository;

public final class TableMetaDataPersistEnabledService
implements TableMetaDataPersistService {
    private final PersistRepository repository;
    private final VersionPersistService versionPersistService;
    private final YamlTableSwapper swapper = new YamlTableSwapper();

    @Override
    public Collection<ShardingSphereTable> load(String databaseName, String schemaName) {
        return this.repository.getChildrenKeys(NodePathGenerator.toPath((NodePath)new TableMetaDataNodePath(databaseName, schemaName, null))).stream().map(each -> this.load(databaseName, schemaName, (String)each)).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toList());
    }

    @Override
    public Optional<ShardingSphereTable> load(String databaseName, String schemaName, String tableName) {
        VersionNodePath versionNodePath = new VersionNodePath((NodePath)new TableMetaDataNodePath(databaseName, schemaName, tableName));
        String activeVersion = this.repository.query(versionNodePath.getActiveVersionPath());
        if (Strings.isNullOrEmpty((String)activeVersion)) {
            return Optional.empty();
        }
        String tableContent = this.repository.query(versionNodePath.getVersionPath(Integer.parseInt(activeVersion)));
        if (Strings.isNullOrEmpty((String)tableContent)) {
            return Optional.empty();
        }
        return Optional.of(this.swapper.swapToObject((YamlShardingSphereTable)YamlEngine.unmarshal((String)tableContent, YamlShardingSphereTable.class)));
    }

    @Override
    public void persist(String databaseName, String schemaName, Collection<ShardingSphereTable> tables) {
        for (ShardingSphereTable each : tables) {
            String tableName = each.getName().toLowerCase();
            VersionNodePath versionNodePath = new VersionNodePath((NodePath)new TableMetaDataNodePath(databaseName, schemaName, tableName));
            this.versionPersistService.persist(versionNodePath, YamlEngine.marshal((Object)this.swapper.swapToYamlConfiguration(each)));
        }
    }

    @Override
    public void drop(String databaseName, String schemaName, String tableName) {
        this.repository.delete(NodePathGenerator.toPath((NodePath)new TableMetaDataNodePath(databaseName, schemaName, tableName.toLowerCase())));
    }

    @Override
    public void drop(String databaseName, String schemaName, Collection<ShardingSphereTable> tables) {
        tables.forEach(each -> this.drop(databaseName, schemaName, each.getName()));
    }

    @Generated
    public TableMetaDataPersistEnabledService(PersistRepository repository, VersionPersistService versionPersistService) {
        this.repository = repository;
        this.versionPersistService = versionPersistService;
    }
}

