/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.mode.metadata.persist.metadata.service;

import java.util.Collection;
import java.util.Collections;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.shardingsphere.database.connector.core.type.DatabaseType;
import org.apache.shardingsphere.infra.metadata.database.schema.manager.GenericSchemaManager;
import org.apache.shardingsphere.infra.metadata.database.schema.model.ShardingSphereSchema;
import org.apache.shardingsphere.mode.metadata.persist.metadata.service.ViewMetaDataPersistService;
import org.apache.shardingsphere.mode.node.path.NodePath;
import org.apache.shardingsphere.mode.node.path.engine.generator.NodePathGenerator;
import org.apache.shardingsphere.mode.node.path.type.database.metadata.schema.SchemaMetaDataNodePath;
import org.apache.shardingsphere.mode.node.path.type.database.metadata.schema.TableMetaDataNodePath;
import org.apache.shardingsphere.mode.persist.service.TableMetaDataPersistService;
import org.apache.shardingsphere.mode.spi.repository.PersistRepository;

public final class SchemaMetaDataPersistService {
    private final PersistRepository repository;
    private final TableMetaDataPersistService tableMetaDataPersistService;
    private final ViewMetaDataPersistService viewMetaDataPersistService;

    public void add(String databaseName, String schemaName) {
        this.repository.persist(NodePathGenerator.toPath((NodePath)new TableMetaDataNodePath(databaseName, schemaName, null)), "");
    }

    public void drop(String databaseName, String schemaName) {
        this.repository.delete(NodePathGenerator.toPath((NodePath)new SchemaMetaDataNodePath(databaseName, schemaName)));
    }

    public void alterByRefresh(String databaseName, ShardingSphereSchema schema) {
        String schemaName = schema.getName().toLowerCase();
        if (schema.isEmpty()) {
            this.add(databaseName, schemaName);
        }
        ShardingSphereSchema currentSchema = new ShardingSphereSchema(schemaName, schema.getProtocolType(), this.tableMetaDataPersistService.load(databaseName, schemaName), Collections.emptyList());
        this.tableMetaDataPersistService.persist(databaseName, schemaName, GenericSchemaManager.getToBeAddedTables((ShardingSphereSchema)schema, (ShardingSphereSchema)currentSchema));
        GenericSchemaManager.getToBeDroppedTables((ShardingSphereSchema)schema, (ShardingSphereSchema)currentSchema).forEach(each -> this.tableMetaDataPersistService.drop(databaseName, schemaName, each.getName()));
    }

    public Collection<ShardingSphereSchema> load(String databaseName, DatabaseType protocolType) {
        return this.repository.getChildrenKeys(NodePathGenerator.toPath((NodePath)new SchemaMetaDataNodePath(databaseName, null))).stream().map(each -> new ShardingSphereSchema(each, protocolType, this.tableMetaDataPersistService.load(databaseName, (String)each), this.viewMetaDataPersistService.load(databaseName, (String)each))).collect(Collectors.toList());
    }

    @Generated
    public SchemaMetaDataPersistService(PersistRepository repository, TableMetaDataPersistService tableMetaDataPersistService, ViewMetaDataPersistService viewMetaDataPersistService) {
        this.repository = repository;
        this.tableMetaDataPersistService = tableMetaDataPersistService;
        this.viewMetaDataPersistService = viewMetaDataPersistService;
    }
}

