/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.mode.metadata.persist.config.global;

import com.google.common.base.Strings;
import java.util.Optional;
import java.util.Properties;
import lombok.Generated;
import org.apache.shardingsphere.infra.util.yaml.YamlEngine;
import org.apache.shardingsphere.mode.metadata.persist.version.VersionPersistService;
import org.apache.shardingsphere.mode.node.path.NodePath;
import org.apache.shardingsphere.mode.node.path.type.global.config.GlobalPropertiesNodePath;
import org.apache.shardingsphere.mode.node.path.version.VersionNodePath;
import org.apache.shardingsphere.mode.spi.repository.PersistRepository;

public final class PropertiesPersistService {
    private final PersistRepository repository;
    private final VersionPersistService versionPersistService;

    public Properties load() {
        return this.loadActiveVersion().map(optional -> (Properties)YamlEngine.unmarshal((String)this.repository.query(new VersionNodePath((NodePath)new GlobalPropertiesNodePath()).getVersionPath(optional.intValue())), Properties.class)).orElse(new Properties());
    }

    private Optional<Integer> loadActiveVersion() {
        String value = this.repository.query(new VersionNodePath((NodePath)new GlobalPropertiesNodePath()).getActiveVersionPath());
        return Strings.isNullOrEmpty((String)value) ? Optional.empty() : Optional.of(Integer.parseInt(value));
    }

    public void persist(Properties props) {
        VersionNodePath versionNodePath = new VersionNodePath((NodePath)new GlobalPropertiesNodePath());
        this.versionPersistService.persist(versionNodePath, YamlEngine.marshal((Object)props));
    }

    @Generated
    public PropertiesPersistService(PersistRepository repository, VersionPersistService versionPersistService) {
        this.repository = repository;
        this.versionPersistService = versionPersistService;
    }
}

