/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.mode.metadata.persist.config.global;

import java.util.Collection;
import java.util.stream.Collectors;
import org.apache.shardingsphere.infra.config.rule.RuleConfiguration;
import org.apache.shardingsphere.infra.yaml.config.pojo.rule.YamlGlobalRuleConfiguration;
import org.apache.shardingsphere.infra.yaml.config.pojo.rule.YamlRuleConfiguration;
import org.apache.shardingsphere.infra.yaml.config.swapper.rule.YamlRuleConfigurationSwapperEngine;
import org.apache.shardingsphere.mode.metadata.persist.version.VersionPersistService;
import org.apache.shardingsphere.mode.node.path.NodePath;
import org.apache.shardingsphere.mode.node.path.engine.generator.NodePathGenerator;
import org.apache.shardingsphere.mode.node.path.type.global.config.GlobalRuleNodePath;
import org.apache.shardingsphere.mode.node.path.version.VersionNodePath;
import org.apache.shardingsphere.mode.node.rule.tuple.RuleNodeTuple;
import org.apache.shardingsphere.mode.node.rule.tuple.YamlRuleNodeTupleSwapperEngine;
import org.apache.shardingsphere.mode.spi.repository.PersistRepository;

public final class GlobalRulePersistService {
    private final PersistRepository repository;
    private final VersionPersistService versionPersistService;
    private final YamlRuleConfigurationSwapperEngine yamlSwapperEngine;
    private final YamlRuleNodeTupleSwapperEngine tupleSwapperEngine;

    public GlobalRulePersistService(PersistRepository repository, VersionPersistService versionPersistService) {
        this.repository = repository;
        this.versionPersistService = versionPersistService;
        this.yamlSwapperEngine = new YamlRuleConfigurationSwapperEngine();
        this.tupleSwapperEngine = new YamlRuleNodeTupleSwapperEngine();
    }

    public Collection<RuleConfiguration> load() {
        return this.repository.getChildrenKeys(NodePathGenerator.toPath((NodePath)new GlobalRuleNodePath(null))).stream().map(this::load).collect(Collectors.toList());
    }

    public RuleConfiguration load(String ruleType) {
        String ruleContent = this.versionPersistService.loadContent(new VersionNodePath((NodePath)new GlobalRuleNodePath(ruleType)));
        return this.yamlSwapperEngine.swapToRuleConfiguration(this.tupleSwapperEngine.swapToYamlGlobalRuleConfiguration(ruleType, ruleContent));
    }

    public void persist(Collection<RuleConfiguration> globalRuleConfigs) {
        for (YamlRuleConfiguration each : this.yamlSwapperEngine.swapToYamlRuleConfigurations(globalRuleConfigs)) {
            this.persistTuple(this.tupleSwapperEngine.swapToTuple((YamlGlobalRuleConfiguration)each));
        }
    }

    private void persistTuple(RuleNodeTuple tuple) {
        this.versionPersistService.persist(new VersionNodePath(tuple.getNodePath()), tuple.getContent());
    }
}

