/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.mode.metadata.persist.config.database;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.shardingsphere.infra.config.rule.RuleConfiguration;
import org.apache.shardingsphere.infra.yaml.config.pojo.rule.YamlRuleConfiguration;
import org.apache.shardingsphere.infra.yaml.config.swapper.rule.YamlRuleConfigurationSwapperEngine;
import org.apache.shardingsphere.mode.metadata.persist.version.VersionPersistService;
import org.apache.shardingsphere.mode.node.path.NodePath;
import org.apache.shardingsphere.mode.node.path.engine.generator.NodePathGenerator;
import org.apache.shardingsphere.mode.node.path.type.database.metadata.rule.DatabaseRuleItem;
import org.apache.shardingsphere.mode.node.path.type.database.metadata.rule.DatabaseRuleNodePath;
import org.apache.shardingsphere.mode.node.path.version.MetaDataVersion;
import org.apache.shardingsphere.mode.node.path.version.VersionNodePath;
import org.apache.shardingsphere.mode.node.rule.node.DatabaseRuleNode;
import org.apache.shardingsphere.mode.node.rule.node.DatabaseRuleNodeGenerator;
import org.apache.shardingsphere.mode.node.rule.tuple.RuleNodeTuple;
import org.apache.shardingsphere.mode.node.rule.tuple.YamlRuleNodeTupleSwapperEngine;
import org.apache.shardingsphere.mode.spi.repository.PersistRepository;

public final class DatabaseRulePersistService {
    private final PersistRepository repository;
    private final VersionPersistService versionPersistService;
    private final YamlRuleConfigurationSwapperEngine yamlSwapperEngine;
    private final YamlRuleNodeTupleSwapperEngine tupleSwapperEngine;

    public DatabaseRulePersistService(PersistRepository repository) {
        this.repository = repository;
        this.versionPersistService = new VersionPersistService(repository);
        this.yamlSwapperEngine = new YamlRuleConfigurationSwapperEngine();
        this.tupleSwapperEngine = new YamlRuleNodeTupleSwapperEngine();
    }

    public Collection<RuleConfiguration> load(String databaseName) {
        return this.repository.getChildrenKeys(NodePathGenerator.toPath((NodePath)new DatabaseRuleNodePath(databaseName, null, null))).stream().map(each -> this.load(databaseName, (String)each)).collect(Collectors.toList());
    }

    private RuleConfiguration load(String databaseName, String ruleType) {
        return this.yamlSwapperEngine.swapToRuleConfiguration(this.tupleSwapperEngine.swapToYamlDatabaseRuleConfiguration(databaseName, ruleType, this.load(databaseName, DatabaseRuleNodeGenerator.generate((String)ruleType))));
    }

    private Collection<RuleNodeTuple> load(String databaseName, DatabaseRuleNode databaseRuleNode) {
        LinkedList<DatabaseRuleNodePath> nodePaths = new LinkedList<DatabaseRuleNodePath>();
        nodePaths.addAll(this.getUniqueItemNodePaths(databaseName, databaseRuleNode.getRuleType(), databaseRuleNode.getUniqueItems()));
        nodePaths.addAll(this.getNamedItemNodePaths(databaseName, databaseRuleNode.getRuleType(), databaseRuleNode.getNamedItems()));
        return nodePaths.stream().map(each -> new RuleNodeTuple((NodePath)each, this.versionPersistService.loadContent(new VersionNodePath((NodePath)each)))).filter(Objects::nonNull).collect(Collectors.toList());
    }

    private Collection<DatabaseRuleNodePath> getUniqueItemNodePaths(String databaseName, String ruleType, Collection<String> uniqueItems) {
        return uniqueItems.stream().map(each -> new DatabaseRuleNodePath(databaseName, ruleType, new DatabaseRuleItem(each))).collect(Collectors.toList());
    }

    private Collection<DatabaseRuleNodePath> getNamedItemNodePaths(String databaseName, String ruleType, Collection<String> namedItems) {
        return namedItems.stream().flatMap(each -> this.getNamedItemNodePaths(databaseName, ruleType, (String)each).stream()).collect(Collectors.toList());
    }

    private Collection<DatabaseRuleNodePath> getNamedItemNodePaths(String databaseName, String ruleType, String namedItem) {
        return this.repository.getChildrenKeys(NodePathGenerator.toPath((NodePath)new DatabaseRuleNodePath(databaseName, ruleType, new DatabaseRuleItem(namedItem)))).stream().map(each -> new DatabaseRuleNodePath(databaseName, ruleType, new DatabaseRuleItem(namedItem, each))).collect(Collectors.toList());
    }

    public Collection<MetaDataVersion> persist(String databaseName, Collection<RuleConfiguration> configs) {
        LinkedList<MetaDataVersion> result = new LinkedList<MetaDataVersion>();
        for (YamlRuleConfiguration each : this.yamlSwapperEngine.swapToYamlRuleConfigurations(configs)) {
            result.addAll(this.persistTuples(this.tupleSwapperEngine.swapToTuples(databaseName, each)));
        }
        return result;
    }

    private Collection<MetaDataVersion> persistTuples(Collection<RuleNodeTuple> tuples) {
        return tuples.stream().map(each -> new MetaDataVersion(each.getNodePath(), Math.max(0, this.versionPersistService.persist(new VersionNodePath(each.getNodePath()), each.getContent()) - 1))).collect(Collectors.toList());
    }

    public void delete(String databaseName, String ruleType) {
        this.repository.delete(NodePathGenerator.toPath((NodePath)new DatabaseRuleNodePath(databaseName, ruleType, null)));
    }

    public Collection<MetaDataVersion> delete(String databaseName, Collection<RuleConfiguration> configs) {
        LinkedList<MetaDataVersion> result = new LinkedList<MetaDataVersion>();
        for (YamlRuleConfiguration each : this.yamlSwapperEngine.swapToYamlRuleConfigurations(configs)) {
            LinkedList<RuleNodeTuple> tuples = new LinkedList<RuleNodeTuple>(this.tupleSwapperEngine.swapToTuples(databaseName, each));
            Collections.reverse(tuples);
            result.addAll(this.deleteTuples(tuples));
        }
        return result;
    }

    private Collection<MetaDataVersion> deleteTuples(Collection<RuleNodeTuple> tuples) {
        LinkedList<MetaDataVersion> result = new LinkedList<MetaDataVersion>();
        for (RuleNodeTuple each : tuples) {
            this.repository.delete(each.getPath());
            result.add(new MetaDataVersion(each.getNodePath()));
        }
        return result;
    }
}

