/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.mode.metadata.persist;

import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.stream.Collectors;
import javax.sql.DataSource;
import lombok.Generated;
import org.apache.shardingsphere.infra.config.database.DatabaseConfiguration;
import org.apache.shardingsphere.infra.config.rule.RuleConfiguration;
import org.apache.shardingsphere.infra.config.rule.decorator.RuleConfigurationDecorator;
import org.apache.shardingsphere.infra.datasource.pool.config.DataSourceConfiguration;
import org.apache.shardingsphere.infra.datasource.pool.props.creator.DataSourcePoolPropertiesCreator;
import org.apache.shardingsphere.infra.datasource.pool.props.domain.DataSourcePoolProperties;
import org.apache.shardingsphere.infra.metadata.database.resource.unit.StorageUnit;
import org.apache.shardingsphere.infra.rule.ShardingSphereRule;
import org.apache.shardingsphere.infra.spi.type.typed.TypedSPILoader;
import org.apache.shardingsphere.mode.metadata.persist.config.database.DataSourceUnitPersistService;
import org.apache.shardingsphere.mode.metadata.persist.config.database.DatabaseRulePersistService;
import org.apache.shardingsphere.mode.metadata.persist.config.global.GlobalRulePersistService;
import org.apache.shardingsphere.mode.metadata.persist.config.global.PropertiesPersistService;
import org.apache.shardingsphere.mode.metadata.persist.metadata.DatabaseMetaDataPersistFacade;
import org.apache.shardingsphere.mode.metadata.persist.statistics.StatisticsPersistService;
import org.apache.shardingsphere.mode.metadata.persist.version.VersionPersistService;
import org.apache.shardingsphere.mode.spi.repository.PersistRepository;

public final class MetaDataPersistFacade {
    private final PersistRepository repository;
    private final VersionPersistService versionService;
    private final DataSourceUnitPersistService dataSourceUnitService;
    private final DatabaseMetaDataPersistFacade databaseMetaDataFacade;
    private final DatabaseRulePersistService databaseRuleService;
    private final GlobalRulePersistService globalRuleService;
    private final PropertiesPersistService propsService;
    private final StatisticsPersistService statisticsService;

    public MetaDataPersistFacade(PersistRepository repository, boolean persistSchemasEnabled) {
        this.repository = repository;
        this.versionService = new VersionPersistService(repository);
        this.dataSourceUnitService = new DataSourceUnitPersistService(repository);
        this.databaseMetaDataFacade = new DatabaseMetaDataPersistFacade(repository, this.versionService, persistSchemasEnabled);
        this.databaseRuleService = new DatabaseRulePersistService(repository);
        this.globalRuleService = new GlobalRulePersistService(repository, this.versionService);
        this.propsService = new PropertiesPersistService(repository, this.versionService);
        this.statisticsService = new StatisticsPersistService(repository);
    }

    public MetaDataPersistFacade(PersistRepository repository) {
        this(repository, true);
    }

    public void persistGlobalRuleConfiguration(Collection<RuleConfiguration> globalRuleConfigs, Properties props) {
        this.globalRuleService.persist(globalRuleConfigs);
        this.propsService.persist(props);
    }

    public void persistConfigurations(String databaseName, DatabaseConfiguration databaseConfig, Map<String, DataSource> dataSources, Collection<ShardingSphereRule> rules) {
        Map<String, DataSourcePoolProperties> propsMap = this.getDataSourcePoolPropertiesMap(databaseConfig);
        if (propsMap.isEmpty() && databaseConfig.getRuleConfigurations().isEmpty()) {
            this.databaseMetaDataFacade.getDatabase().add(databaseName);
        } else {
            this.dataSourceUnitService.persist(databaseName, propsMap);
            this.databaseRuleService.persist(databaseName, this.decorateRuleConfigurations(databaseName, dataSources, rules));
        }
    }

    private Collection<RuleConfiguration> decorateRuleConfigurations(String databaseName, Map<String, DataSource> dataSources, Collection<ShardingSphereRule> rules) {
        LinkedList<RuleConfiguration> result = new LinkedList<RuleConfiguration>();
        for (ShardingSphereRule each : rules) {
            RuleConfiguration ruleConfig = each.getConfiguration();
            Optional decorator = TypedSPILoader.findService(RuleConfigurationDecorator.class, ruleConfig.getClass());
            result.add(decorator.map(optional -> optional.decorate(databaseName, dataSources, rules, ruleConfig)).orElse(ruleConfig));
        }
        return result;
    }

    private Map<String, DataSourcePoolProperties> getDataSourcePoolPropertiesMap(DatabaseConfiguration databaseConfig) {
        return databaseConfig.getStorageUnits().entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> ((StorageUnit)entry.getValue()).getDataSourcePoolProperties(), (oldValue, currentValue) -> oldValue, LinkedHashMap::new));
    }

    public Map<String, DataSourceConfiguration> loadDataSourceConfigurations(String databaseName) {
        return this.dataSourceUnitService.load(databaseName).entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> DataSourcePoolPropertiesCreator.createConfiguration((DataSourcePoolProperties)((DataSourcePoolProperties)entry.getValue())), (oldValue, currentValue) -> oldValue, LinkedHashMap::new));
    }

    @Generated
    public PersistRepository getRepository() {
        return this.repository;
    }

    @Generated
    public VersionPersistService getVersionService() {
        return this.versionService;
    }

    @Generated
    public DataSourceUnitPersistService getDataSourceUnitService() {
        return this.dataSourceUnitService;
    }

    @Generated
    public DatabaseMetaDataPersistFacade getDatabaseMetaDataFacade() {
        return this.databaseMetaDataFacade;
    }

    @Generated
    public DatabaseRulePersistService getDatabaseRuleService() {
        return this.databaseRuleService;
    }

    @Generated
    public GlobalRulePersistService getGlobalRuleService() {
        return this.globalRuleService;
    }

    @Generated
    public PropertiesPersistService getPropsService() {
        return this.propsService;
    }

    @Generated
    public StatisticsPersistService getStatisticsService() {
        return this.statisticsService;
    }
}

