/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.mode.metadata.manager.statistics;

import java.util.ArrayList;
import lombok.Generated;
import org.apache.shardingsphere.infra.metadata.statistics.DatabaseStatistics;
import org.apache.shardingsphere.infra.metadata.statistics.SchemaStatistics;
import org.apache.shardingsphere.infra.metadata.statistics.TableStatistics;
import org.apache.shardingsphere.infra.yaml.data.pojo.YamlRowStatistics;
import org.apache.shardingsphere.infra.yaml.data.swapper.YamlRowStatisticsSwapper;
import org.apache.shardingsphere.mode.metadata.MetaDataContexts;

public final class StatisticsManager {
    private final MetaDataContexts metaDataContexts;

    public synchronized void addDatabaseStatistics(String databaseName) {
        if (this.metaDataContexts.getStatistics().containsDatabaseStatistics(databaseName)) {
            return;
        }
        this.metaDataContexts.getStatistics().putDatabaseStatistics(databaseName, new DatabaseStatistics());
    }

    public synchronized void dropDatabaseStatistics(String databaseName) {
        if (!this.metaDataContexts.getStatistics().containsDatabaseStatistics(databaseName)) {
            return;
        }
        this.metaDataContexts.getStatistics().dropDatabaseStatistics(databaseName);
    }

    public synchronized void addSchemaStatistics(String databaseName, String schemaName) {
        if (this.metaDataContexts.getStatistics().getDatabaseStatistics(databaseName).containsSchemaStatistics(schemaName)) {
            return;
        }
        this.metaDataContexts.getStatistics().getDatabaseStatistics(databaseName).putSchemaStatistics(schemaName, new SchemaStatistics());
    }

    public synchronized void dropSchemaStatistics(String databaseName, String schemaName) {
        DatabaseStatistics databaseStatistics = this.metaDataContexts.getStatistics().getDatabaseStatistics(databaseName);
        if (null == databaseStatistics || !databaseStatistics.containsSchemaStatistics(schemaName)) {
            return;
        }
        databaseStatistics.removeSchemaStatistics(schemaName);
    }

    public synchronized void addTableStatistics(String databaseName, String schemaName, String tableName) {
        if (!this.metaDataContexts.getStatistics().containsDatabaseStatistics(databaseName) || !this.metaDataContexts.getStatistics().getDatabaseStatistics(databaseName).containsSchemaStatistics(schemaName)) {
            return;
        }
        if (this.metaDataContexts.getStatistics().getDatabaseStatistics(databaseName).getSchemaStatistics(schemaName).containsTableStatistics(tableName)) {
            return;
        }
        this.metaDataContexts.getStatistics().getDatabaseStatistics(databaseName).getSchemaStatistics(schemaName).putTableStatistics(tableName, new TableStatistics(tableName));
    }

    public synchronized void dropTableStatistics(String databaseName, String schemaName, String tableName) {
        if (!this.metaDataContexts.getStatistics().containsDatabaseStatistics(databaseName) || !this.metaDataContexts.getStatistics().getDatabaseStatistics(databaseName).containsSchemaStatistics(schemaName)) {
            return;
        }
        this.metaDataContexts.getStatistics().getDatabaseStatistics(databaseName).getSchemaStatistics(schemaName).removeTableStatistics(tableName);
    }

    public synchronized void alterRowStatistics(String databaseName, String schemaName, String tableName, YamlRowStatistics yamlRowData) {
        if (!(this.metaDataContexts.getStatistics().containsDatabaseStatistics(databaseName) && this.metaDataContexts.getStatistics().getDatabaseStatistics(databaseName).containsSchemaStatistics(schemaName) && this.metaDataContexts.getStatistics().getDatabaseStatistics(databaseName).getSchemaStatistics(schemaName).containsTableStatistics(tableName))) {
            return;
        }
        if (!(this.metaDataContexts.getMetaData().containsDatabase(databaseName) && this.metaDataContexts.getMetaData().getDatabase(databaseName).containsSchema(schemaName) && this.metaDataContexts.getMetaData().getDatabase(databaseName).getSchema(schemaName).containsTable(tableName))) {
            return;
        }
        TableStatistics tableStatistics = this.metaDataContexts.getStatistics().getDatabaseStatistics(databaseName).getSchemaStatistics(schemaName).getTableStatistics(tableName);
        ArrayList columns = new ArrayList(this.metaDataContexts.getMetaData().getDatabase(databaseName).getSchema(schemaName).getTable(tableName).getAllColumns());
        tableStatistics.getRows().add(new YamlRowStatisticsSwapper(columns).swapToObject(yamlRowData));
    }

    public synchronized void deleteRowStatistics(String databaseName, String schemaName, String tableName, String uniqueKey) {
        if (!(this.metaDataContexts.getStatistics().containsDatabaseStatistics(databaseName) && this.metaDataContexts.getStatistics().getDatabaseStatistics(databaseName).containsSchemaStatistics(schemaName) && this.metaDataContexts.getStatistics().getDatabaseStatistics(databaseName).getSchemaStatistics(schemaName).containsTableStatistics(tableName))) {
            return;
        }
        this.metaDataContexts.getStatistics().getDatabaseStatistics(databaseName).getSchemaStatistics(schemaName).getTableStatistics(tableName).getRows().removeIf(each -> uniqueKey.equals(each.getUniqueKey()));
    }

    @Generated
    public StatisticsManager(MetaDataContexts metaDataContexts) {
        this.metaDataContexts = metaDataContexts;
    }
}

