/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.mode.metadata.manager.rule;

import java.util.Collection;
import java.util.LinkedList;
import java.util.Properties;
import lombok.Generated;
import org.apache.shardingsphere.infra.config.props.ConfigurationProperties;
import org.apache.shardingsphere.infra.config.props.temporary.TemporaryConfigurationProperties;
import org.apache.shardingsphere.infra.config.props.temporary.TemporaryConfigurationPropertyKey;
import org.apache.shardingsphere.infra.config.rule.RuleConfiguration;
import org.apache.shardingsphere.infra.metadata.ShardingSphereMetaData;
import org.apache.shardingsphere.infra.rule.ShardingSphereRule;
import org.apache.shardingsphere.infra.rule.builder.global.GlobalRulesBuilder;
import org.apache.shardingsphere.infra.spi.ShardingSphereServiceLoader;
import org.apache.shardingsphere.mode.manager.listener.StatisticsCollectJobCronUpdateListener;
import org.apache.shardingsphere.mode.metadata.MetaDataContexts;
import org.apache.shardingsphere.mode.metadata.persist.MetaDataPersistFacade;

public final class GlobalConfigurationManager {
    private final MetaDataContexts metaDataContexts;
    private final MetaDataPersistFacade metaDataPersistFacade;

    public synchronized void alterGlobalRuleConfiguration(RuleConfiguration ruleConfig) {
        if (null == ruleConfig) {
            return;
        }
        Collection<ShardingSphereRule> rules = this.removeGlobalRule(ruleConfig, this.metaDataContexts.getMetaData().getGlobalRuleMetaData().getRules());
        rules.addAll(GlobalRulesBuilder.buildSingleRules((RuleConfiguration)ruleConfig, (Collection)this.metaDataContexts.getMetaData().getAllDatabases(), (ConfigurationProperties)this.metaDataContexts.getMetaData().getProps()));
        this.metaDataContexts.getMetaData().getGlobalRuleMetaData().getRules().clear();
        this.metaDataContexts.getMetaData().getGlobalRuleMetaData().getRules().addAll(rules);
        this.metaDataContexts.update(new ShardingSphereMetaData(this.metaDataContexts.getMetaData().getAllDatabases(), this.metaDataContexts.getMetaData().getGlobalResourceMetaData(), this.metaDataContexts.getMetaData().getGlobalRuleMetaData(), this.metaDataContexts.getMetaData().getProps()), this.metaDataPersistFacade);
    }

    private Collection<ShardingSphereRule> removeGlobalRule(RuleConfiguration ruleConfig, Collection<ShardingSphereRule> rules) {
        LinkedList<ShardingSphereRule> result = new LinkedList<ShardingSphereRule>();
        for (ShardingSphereRule each : rules) {
            if (!each.getConfiguration().getClass().isAssignableFrom(ruleConfig.getClass())) {
                result.add(each);
                continue;
            }
            if (!(each instanceof AutoCloseable)) continue;
            ((AutoCloseable)each).close();
        }
        return result;
    }

    public synchronized void alterProperties(Properties props) {
        boolean isProxyMetaDataCollectorCronChanged = this.isProxyMetaDataCollectorCronChanged(props);
        this.metaDataContexts.update(new ShardingSphereMetaData(this.metaDataContexts.getMetaData().getAllDatabases(), this.metaDataContexts.getMetaData().getGlobalResourceMetaData(), this.metaDataContexts.getMetaData().getGlobalRuleMetaData(), new ConfigurationProperties(props)), this.metaDataPersistFacade);
        if (isProxyMetaDataCollectorCronChanged) {
            for (StatisticsCollectJobCronUpdateListener each : ShardingSphereServiceLoader.getServiceInstances(StatisticsCollectJobCronUpdateListener.class)) {
                each.updated();
            }
        }
    }

    private boolean isProxyMetaDataCollectorCronChanged(Properties props) {
        String newValue;
        String currentValue = (String)this.metaDataContexts.getMetaData().getTemporaryProps().getValue((Enum)TemporaryConfigurationPropertyKey.PROXY_META_DATA_COLLECTOR_CRON);
        return !currentValue.equalsIgnoreCase(newValue = (String)new TemporaryConfigurationProperties(props).getValue((Enum)TemporaryConfigurationPropertyKey.PROXY_META_DATA_COLLECTOR_CRON));
    }

    @Generated
    public GlobalConfigurationManager(MetaDataContexts metaDataContexts, MetaDataPersistFacade metaDataPersistFacade) {
        this.metaDataContexts = metaDataContexts;
        this.metaDataPersistFacade = metaDataPersistFacade;
    }
}

