/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.mode.metadata.manager.rule;

import java.sql.SQLException;
import java.util.Collection;
import java.util.LinkedList;
import java.util.Optional;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.shardingsphere.database.connector.core.type.DatabaseType;
import org.apache.shardingsphere.infra.config.rule.RuleConfiguration;
import org.apache.shardingsphere.infra.instance.ComputeNodeInstanceContext;
import org.apache.shardingsphere.infra.metadata.database.ShardingSphereDatabase;
import org.apache.shardingsphere.infra.metadata.database.resource.ResourceMetaData;
import org.apache.shardingsphere.infra.rule.PartialRuleUpdateSupported;
import org.apache.shardingsphere.infra.rule.ShardingSphereRule;
import org.apache.shardingsphere.infra.rule.builder.database.DatabaseRulesBuilder;
import org.apache.shardingsphere.mode.metadata.MetaDataContexts;
import org.apache.shardingsphere.mode.metadata.factory.MetaDataContextsFactory;
import org.apache.shardingsphere.mode.metadata.persist.MetaDataPersistFacade;

public final class DatabaseRuleConfigurationManager {
    private final MetaDataContexts metaDataContexts;
    private final ComputeNodeInstanceContext computeNodeInstanceContext;
    private final MetaDataPersistFacade metaDataPersistFacade;

    public synchronized void refresh(String databaseName, RuleConfiguration ruleConfig, boolean reBuildRules) throws SQLException {
        ShardingSphereDatabase database = this.metaDataContexts.getMetaData().getDatabase(databaseName);
        LinkedList<ShardingSphereRule> rules = new LinkedList<ShardingSphereRule>(database.getRuleMetaData().getRules());
        Optional<ShardingSphereRule> toBeChangedRule = rules.stream().filter(each -> each.getConfiguration().getClass().equals(ruleConfig.getClass())).findFirst();
        if (toBeChangedRule.isPresent() && toBeChangedRule.get() instanceof PartialRuleUpdateSupported) {
            boolean needRefreshSchemas = ((PartialRuleUpdateSupported)toBeChangedRule.get()).partialUpdate(ruleConfig);
            ((PartialRuleUpdateSupported)toBeChangedRule.get()).updateConfiguration(ruleConfig);
            if (needRefreshSchemas) {
                this.refreshMetadata(databaseName, ruleConfig, reBuildRules, database, rules);
            }
        } else {
            this.refreshMetadata(databaseName, ruleConfig, reBuildRules, database, rules);
        }
    }

    private void refreshMetadata(String databaseName, RuleConfiguration ruleConfig, boolean reBuildRules, ShardingSphereDatabase database, Collection<ShardingSphereRule> rules) throws SQLException {
        Collection toBeRemovedRules = rules.stream().filter(each -> each.getConfiguration().getClass().isAssignableFrom(ruleConfig.getClass())).collect(Collectors.toList());
        rules.removeAll(toBeRemovedRules);
        if (reBuildRules) {
            rules.add(DatabaseRulesBuilder.build((String)databaseName, (DatabaseType)database.getProtocolType(), (Collection)database.getRuleMetaData().getRules(), (RuleConfiguration)ruleConfig, (ComputeNodeInstanceContext)this.computeNodeInstanceContext, (ResourceMetaData)database.getResourceMetaData()));
        }
        this.refreshMetadata(databaseName, rules, toBeRemovedRules);
    }

    private void refreshMetadata(String databaseName, Collection<ShardingSphereRule> rules, Collection<ShardingSphereRule> toBeRemovedRules) throws SQLException {
        Collection ruleConfigs = rules.stream().map(ShardingSphereRule::getConfiguration).collect(Collectors.toList());
        this.metaDataContexts.update(new MetaDataContextsFactory(this.metaDataPersistFacade, this.computeNodeInstanceContext).createByAlterRule(databaseName, false, ruleConfigs, this.metaDataContexts));
        this.closeOriginalRules(toBeRemovedRules);
    }

    private void closeOriginalRules(Collection<ShardingSphereRule> toBeRemovedRules) {
        for (ShardingSphereRule each : toBeRemovedRules) {
            if (!(each instanceof AutoCloseable)) continue;
            ((AutoCloseable)each).close();
        }
    }

    @Generated
    public DatabaseRuleConfigurationManager(MetaDataContexts metaDataContexts, ComputeNodeInstanceContext computeNodeInstanceContext, MetaDataPersistFacade metaDataPersistFacade) {
        this.metaDataContexts = metaDataContexts;
        this.computeNodeInstanceContext = computeNodeInstanceContext;
        this.metaDataPersistFacade = metaDataPersistFacade;
    }
}

