/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.mode.metadata.manager.resource;

import java.sql.SQLException;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.shardingsphere.infra.config.props.temporary.TemporaryConfigurationPropertyKey;
import org.apache.shardingsphere.infra.datasource.pool.props.domain.DataSourcePoolProperties;
import org.apache.shardingsphere.infra.instance.ComputeNodeInstanceContext;
import org.apache.shardingsphere.infra.metadata.database.ShardingSphereDatabase;
import org.apache.shardingsphere.infra.metadata.database.schema.model.ShardingSphereSchema;
import org.apache.shardingsphere.infra.rule.ShardingSphereRule;
import org.apache.shardingsphere.mode.metadata.MetaDataContexts;
import org.apache.shardingsphere.mode.metadata.factory.MetaDataContextsFactory;
import org.apache.shardingsphere.mode.metadata.manager.resource.ResourceSwitchManager;
import org.apache.shardingsphere.mode.metadata.manager.resource.SwitchingResource;
import org.apache.shardingsphere.mode.metadata.persist.MetaDataPersistFacade;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class StorageUnitManager {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(StorageUnitManager.class);
    private final MetaDataContexts metaDataContexts;
    private final ComputeNodeInstanceContext computeNodeInstanceContext;
    private final ResourceSwitchManager resourceSwitchManager;
    private final MetaDataPersistFacade metaDataPersistFacade;

    public synchronized void register(String databaseName, Map<String, DataSourcePoolProperties> propsMap) {
        ShardingSphereDatabase database = this.metaDataContexts.getMetaData().getDatabase(databaseName);
        try {
            this.closeStaleRules(database);
            boolean isInstanceConnectionEnabled = (Boolean)this.metaDataContexts.getMetaData().getTemporaryProps().getValue((Enum)TemporaryConfigurationPropertyKey.INSTANCE_CONNECTION_ENABLED);
            SwitchingResource switchingResource = this.resourceSwitchManager.switchByRegisterStorageUnit(database.getResourceMetaData(), propsMap, isInstanceConnectionEnabled);
            this.buildNewMetaDataContext(databaseName, switchingResource, true);
        }
        catch (SQLException ex) {
            log.error("Alter database: {} register storage unit failed.", (Object)databaseName, (Object)ex);
        }
    }

    public synchronized void alter(String databaseName, Map<String, DataSourcePoolProperties> propsMap) {
        ShardingSphereDatabase database = this.metaDataContexts.getMetaData().getDatabase(databaseName);
        try {
            this.closeStaleRules(database);
            boolean isInstanceConnectionEnabled = (Boolean)this.metaDataContexts.getMetaData().getTemporaryProps().getValue((Enum)TemporaryConfigurationPropertyKey.INSTANCE_CONNECTION_ENABLED);
            SwitchingResource switchingResource = this.resourceSwitchManager.switchByAlterStorageUnit(database.getResourceMetaData(), propsMap, isInstanceConnectionEnabled);
            this.buildNewMetaDataContext(databaseName, switchingResource, true);
        }
        catch (SQLException ex) {
            log.error("Alter database: {} alter storage unit failed.", (Object)databaseName, (Object)ex);
        }
    }

    public synchronized void unregister(String databaseName, String storageUnitName) {
        ShardingSphereDatabase database = this.metaDataContexts.getMetaData().getDatabase(databaseName);
        try {
            this.closeStaleRules(database);
            SwitchingResource switchingResource = this.resourceSwitchManager.switchByUnregisterStorageUnit(database.getResourceMetaData(), Collections.singleton(storageUnitName));
            this.buildNewMetaDataContext(databaseName, switchingResource, false);
        }
        catch (SQLException ex) {
            log.error("Alter database: {} register storage unit failed.", (Object)databaseName, (Object)ex);
        }
    }

    private void buildNewMetaDataContext(String databaseName, SwitchingResource switchingResource, boolean isLoadSchemasFromRegisterCenter) throws SQLException {
        MetaDataContexts reloadMetaDataContexts = new MetaDataContextsFactory(this.metaDataPersistFacade, this.computeNodeInstanceContext).createBySwitchResource(databaseName, isLoadSchemasFromRegisterCenter, switchingResource, this.metaDataContexts);
        this.metaDataContexts.update(reloadMetaDataContexts);
        this.metaDataContexts.getMetaData().putDatabase(this.buildDatabase(reloadMetaDataContexts.getMetaData().getDatabase(databaseName)));
        switchingResource.closeStaleDataSources();
    }

    private ShardingSphereDatabase buildDatabase(ShardingSphereDatabase originalDatabase) {
        return new ShardingSphereDatabase(originalDatabase.getName(), originalDatabase.getProtocolType(), originalDatabase.getResourceMetaData(), originalDatabase.getRuleMetaData(), this.buildSchemas(originalDatabase));
    }

    private Collection<ShardingSphereSchema> buildSchemas(ShardingSphereDatabase originalDatabase) {
        return originalDatabase.getAllSchemas().stream().map(each -> this.buildSchema(originalDatabase, (ShardingSphereSchema)each)).collect(Collectors.toList());
    }

    private ShardingSphereSchema buildSchema(ShardingSphereDatabase originalDatabase, ShardingSphereSchema schema) {
        return new ShardingSphereSchema(schema.getName(), schema.getProtocolType(), schema.getAllTables(), this.metaDataPersistFacade.getDatabaseMetaDataFacade().getView().load(originalDatabase.getName(), schema.getName()));
    }

    private void closeStaleRules(ShardingSphereDatabase database) {
        for (ShardingSphereRule each : database.getRuleMetaData().getRules()) {
            if (!(each instanceof AutoCloseable)) continue;
            ((AutoCloseable)each).close();
        }
    }

    @Generated
    public StorageUnitManager(MetaDataContexts metaDataContexts, ComputeNodeInstanceContext computeNodeInstanceContext, ResourceSwitchManager resourceSwitchManager, MetaDataPersistFacade metaDataPersistFacade) {
        this.metaDataContexts = metaDataContexts;
        this.computeNodeInstanceContext = computeNodeInstanceContext;
        this.resourceSwitchManager = resourceSwitchManager;
        this.metaDataPersistFacade = metaDataPersistFacade;
    }
}

