/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.mode.metadata.factory.init.type;

import java.sql.SQLException;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Properties;
import java.util.stream.Collectors;
import org.apache.shardingsphere.database.connector.core.type.DatabaseType;
import org.apache.shardingsphere.infra.config.database.DatabaseConfiguration;
import org.apache.shardingsphere.infra.config.props.ConfigurationProperties;
import org.apache.shardingsphere.infra.config.props.ConfigurationPropertyKey;
import org.apache.shardingsphere.infra.database.DatabaseTypeEngine;
import org.apache.shardingsphere.infra.instance.ComputeNodeInstanceContext;
import org.apache.shardingsphere.infra.metadata.database.ShardingSphereDatabase;
import org.apache.shardingsphere.infra.metadata.database.ShardingSphereDatabasesFactory;
import org.apache.shardingsphere.infra.metadata.database.resource.unit.StorageUnit;
import org.apache.shardingsphere.infra.metadata.statistics.DatabaseStatistics;
import org.apache.shardingsphere.infra.metadata.statistics.SchemaStatistics;
import org.apache.shardingsphere.mode.manager.builder.ContextManagerBuilderParameter;
import org.apache.shardingsphere.mode.metadata.MetaDataContexts;
import org.apache.shardingsphere.mode.metadata.factory.init.MetaDataContextsInitFactory;
import org.apache.shardingsphere.mode.metadata.persist.MetaDataPersistFacade;
import org.apache.shardingsphere.mode.spi.repository.PersistRepository;

public final class LocalConfigurationMetaDataContextsInitFactory
extends MetaDataContextsInitFactory {
    private final MetaDataPersistFacade persistFacade;
    private final ComputeNodeInstanceContext instanceContext;
    private final boolean persistSchemasEnabled;

    public LocalConfigurationMetaDataContextsInitFactory(PersistRepository repository, ComputeNodeInstanceContext instanceContext, Properties props) {
        this.persistSchemasEnabled = (Boolean)new ConfigurationProperties(props).getValue((Enum)ConfigurationPropertyKey.PERSIST_SCHEMAS_TO_REPOSITORY_ENABLED);
        this.persistFacade = new MetaDataPersistFacade(repository, this.persistSchemasEnabled);
        this.instanceContext = instanceContext;
    }

    @Override
    public MetaDataContexts create(ContextManagerBuilderParameter param) throws SQLException {
        ConfigurationProperties props = new ConfigurationProperties(param.getProps());
        DatabaseType protocolType = DatabaseTypeEngine.getProtocolType(param.getDatabaseConfigs(), (ConfigurationProperties)props);
        Collection databases = ShardingSphereDatabasesFactory.create(param.getDatabaseConfigs(), (ConfigurationProperties)props, (ComputeNodeInstanceContext)this.instanceContext, (DatabaseType)protocolType);
        MetaDataContexts result = this.create(param.getGlobalRuleConfigs(), param.getGlobalDataSources(), databases, props, this.persistFacade);
        this.persistDatabaseConfigurations(result, param);
        this.persistMetaData(result);
        return result;
    }

    private void persistDatabaseConfigurations(MetaDataContexts metadataContexts, ContextManagerBuilderParameter param) {
        Collection globalRuleConfigs = metadataContexts.getMetaData().getGlobalRuleMetaData().getConfigurations();
        this.persistFacade.persistGlobalRuleConfiguration(globalRuleConfigs, param.getProps());
        for (Map.Entry<String, DatabaseConfiguration> entry : param.getDatabaseConfigs().entrySet()) {
            ShardingSphereDatabase database = metadataContexts.getMetaData().getDatabase(entry.getKey());
            Map dataSources = database.getResourceMetaData().getStorageUnits().entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, each -> ((StorageUnit)each.getValue()).getDataSource(), (oldValue, currentValue) -> oldValue, LinkedHashMap::new));
            this.persistFacade.persistConfigurations(entry.getKey(), entry.getValue(), dataSources, database.getRuleMetaData().getRules());
        }
    }

    private void persistMetaData(MetaDataContexts metaDataContexts) {
        metaDataContexts.getMetaData().getAllDatabases().forEach(each -> each.getAllSchemas().forEach(schema -> {
            if (schema.isEmpty()) {
                this.persistFacade.getDatabaseMetaDataFacade().getSchema().add(each.getName(), schema.getName());
            }
            if (this.persistSchemasEnabled) {
                this.persistFacade.getDatabaseMetaDataFacade().getTable().persist(each.getName(), schema.getName(), schema.getAllTables());
            }
        }));
        for (Map.Entry databaseStatisticsEntry : metaDataContexts.getStatistics().getDatabaseStatisticsMap().entrySet()) {
            for (Map.Entry schemaStatisticsEntry : ((DatabaseStatistics)databaseStatisticsEntry.getValue()).getSchemaStatisticsMap().entrySet()) {
                this.persistFacade.getStatisticsService().persist(metaDataContexts.getMetaData().getDatabase((String)databaseStatisticsEntry.getKey()), (String)schemaStatisticsEntry.getKey(), (SchemaStatistics)schemaStatisticsEntry.getValue());
            }
        }
    }
}

