/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.mode.metadata.factory.init;

import java.sql.SQLException;
import java.util.Collection;
import java.util.Map;
import javax.sql.DataSource;
import org.apache.shardingsphere.infra.config.props.ConfigurationProperties;
import org.apache.shardingsphere.infra.config.rule.RuleConfiguration;
import org.apache.shardingsphere.infra.metadata.ShardingSphereMetaData;
import org.apache.shardingsphere.infra.metadata.database.ShardingSphereDatabase;
import org.apache.shardingsphere.infra.metadata.database.resource.ResourceMetaData;
import org.apache.shardingsphere.infra.metadata.database.rule.RuleMetaData;
import org.apache.shardingsphere.infra.metadata.statistics.ShardingSphereStatistics;
import org.apache.shardingsphere.infra.metadata.statistics.builder.ShardingSphereStatisticsFactory;
import org.apache.shardingsphere.infra.rule.builder.global.GlobalRulesBuilder;
import org.apache.shardingsphere.mode.manager.builder.ContextManagerBuilderParameter;
import org.apache.shardingsphere.mode.metadata.MetaDataContexts;
import org.apache.shardingsphere.mode.metadata.persist.MetaDataPersistFacade;

public abstract class MetaDataContextsInitFactory {
    public abstract MetaDataContexts create(ContextManagerBuilderParameter var1) throws SQLException;

    protected final MetaDataContexts create(Collection<RuleConfiguration> globalRuleConfigs, Map<String, DataSource> globalDataSources, Collection<ShardingSphereDatabase> databases, ConfigurationProperties props, MetaDataPersistFacade persistFacade) {
        Collection globalRules = GlobalRulesBuilder.buildRules(globalRuleConfigs, databases, (ConfigurationProperties)props);
        ShardingSphereMetaData metaData = new ShardingSphereMetaData(databases, new ResourceMetaData(globalDataSources), new RuleMetaData(globalRules), props);
        ShardingSphereStatistics statistics = ShardingSphereStatisticsFactory.create((ShardingSphereMetaData)metaData, (ShardingSphereStatistics)persistFacade.getStatisticsService().load(metaData));
        return new MetaDataContexts(metaData, statistics);
    }
}

