/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.mode.metadata.factory;

import java.sql.SQLException;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.stream.Collectors;
import javax.sql.DataSource;
import lombok.Generated;
import org.apache.shardingsphere.database.connector.core.type.DatabaseType;
import org.apache.shardingsphere.infra.config.database.DatabaseConfiguration;
import org.apache.shardingsphere.infra.config.database.impl.DataSourceProvidedDatabaseConfiguration;
import org.apache.shardingsphere.infra.config.props.ConfigurationProperties;
import org.apache.shardingsphere.infra.config.props.ConfigurationPropertyKey;
import org.apache.shardingsphere.infra.config.props.temporary.TemporaryConfigurationPropertyKey;
import org.apache.shardingsphere.infra.config.rule.RuleConfiguration;
import org.apache.shardingsphere.infra.database.DatabaseTypeEngine;
import org.apache.shardingsphere.infra.instance.ComputeNodeInstanceContext;
import org.apache.shardingsphere.infra.metadata.ShardingSphereMetaData;
import org.apache.shardingsphere.infra.metadata.database.ShardingSphereDatabase;
import org.apache.shardingsphere.infra.metadata.database.ShardingSphereDatabaseFactory;
import org.apache.shardingsphere.infra.metadata.database.resource.ResourceMetaData;
import org.apache.shardingsphere.infra.metadata.database.resource.node.StorageNode;
import org.apache.shardingsphere.infra.metadata.database.resource.unit.StorageUnit;
import org.apache.shardingsphere.infra.metadata.database.rule.RuleMetaData;
import org.apache.shardingsphere.infra.metadata.database.schema.model.ShardingSphereSchema;
import org.apache.shardingsphere.infra.metadata.statistics.ShardingSphereStatistics;
import org.apache.shardingsphere.infra.metadata.statistics.builder.ShardingSphereStatisticsFactory;
import org.apache.shardingsphere.infra.rule.builder.global.GlobalRulesBuilder;
import org.apache.shardingsphere.mode.manager.builder.ContextManagerBuilderParameter;
import org.apache.shardingsphere.mode.metadata.MetaDataContexts;
import org.apache.shardingsphere.mode.metadata.factory.init.MetaDataContextsInitFactory;
import org.apache.shardingsphere.mode.metadata.factory.init.type.LocalConfigurationMetaDataContextsInitFactory;
import org.apache.shardingsphere.mode.metadata.factory.init.type.RegisterCenterMetaDataContextsInitFactory;
import org.apache.shardingsphere.mode.metadata.manager.resource.SwitchingResource;
import org.apache.shardingsphere.mode.metadata.persist.MetaDataPersistFacade;
import org.apache.shardingsphere.mode.metadata.persist.metadata.service.DatabaseMetaDataPersistService;
import org.apache.shardingsphere.mode.spi.repository.PersistRepository;

public final class MetaDataContextsFactory {
    private final MetaDataPersistFacade persistFacade;
    private final ComputeNodeInstanceContext instanceContext;

    public MetaDataContexts create(ContextManagerBuilderParameter param) throws SQLException {
        MetaDataContextsInitFactory initFactory = MetaDataContextsFactory.containsRegisteredDatabases(this.persistFacade.getRepository()) ? new RegisterCenterMetaDataContextsInitFactory(this.persistFacade.getRepository(), this.instanceContext) : new LocalConfigurationMetaDataContextsInitFactory(this.persistFacade.getRepository(), this.instanceContext, param.getProps());
        return initFactory.create(param);
    }

    private static boolean containsRegisteredDatabases(PersistRepository repository) {
        return !new DatabaseMetaDataPersistService(repository).loadAllDatabaseNames().isEmpty();
    }

    public MetaDataContexts createBySwitchResource(String databaseName, boolean isLoadSchemasFromRegisterCenter, SwitchingResource switchingResource, MetaDataContexts originalMetaDataContexts) throws SQLException {
        ShardingSphereDatabase changedDatabase = this.createChangedDatabase(databaseName, isLoadSchemasFromRegisterCenter, switchingResource, null, originalMetaDataContexts);
        ConfigurationProperties props = originalMetaDataContexts.getMetaData().getProps();
        ShardingSphereMetaData clonedMetaData = this.cloneMetaData(originalMetaDataContexts.getMetaData(), changedDatabase);
        RuleMetaData changedGlobalMetaData = new RuleMetaData(GlobalRulesBuilder.buildRules((Collection)originalMetaDataContexts.getMetaData().getGlobalRuleMetaData().getConfigurations(), (Collection)clonedMetaData.getAllDatabases(), (ConfigurationProperties)props));
        ShardingSphereMetaData metaData = new ShardingSphereMetaData(clonedMetaData.getAllDatabases(), originalMetaDataContexts.getMetaData().getGlobalResourceMetaData(), changedGlobalMetaData, props);
        return new MetaDataContexts(metaData, ShardingSphereStatisticsFactory.create((ShardingSphereMetaData)metaData, (ShardingSphereStatistics)this.persistFacade.getStatisticsService().load(metaData)));
    }

    public MetaDataContexts createByAlterRule(String databaseName, boolean isLoadSchemasFromRegisterCenter, Collection<RuleConfiguration> ruleConfigs, MetaDataContexts originalMetaDataContexts) throws SQLException {
        ShardingSphereDatabase changedDatabase = this.createChangedDatabase(databaseName, isLoadSchemasFromRegisterCenter, null, ruleConfigs, originalMetaDataContexts);
        ShardingSphereMetaData clonedMetaData = this.cloneMetaData(originalMetaDataContexts.getMetaData(), changedDatabase);
        ConfigurationProperties props = originalMetaDataContexts.getMetaData().getProps();
        RuleMetaData changedGlobalMetaData = new RuleMetaData(GlobalRulesBuilder.buildRules((Collection)originalMetaDataContexts.getMetaData().getGlobalRuleMetaData().getConfigurations(), (Collection)clonedMetaData.getAllDatabases(), (ConfigurationProperties)props));
        ShardingSphereMetaData metaData = new ShardingSphereMetaData(clonedMetaData.getAllDatabases(), originalMetaDataContexts.getMetaData().getGlobalResourceMetaData(), changedGlobalMetaData, props);
        return new MetaDataContexts(metaData, ShardingSphereStatisticsFactory.create((ShardingSphereMetaData)metaData, (ShardingSphereStatistics)this.persistFacade.getStatisticsService().load(metaData)));
    }

    private ShardingSphereMetaData cloneMetaData(ShardingSphereMetaData originalMetaData, ShardingSphereDatabase changedDatabase) {
        ShardingSphereMetaData result = new ShardingSphereMetaData(originalMetaData.getAllDatabases(), originalMetaData.getGlobalResourceMetaData(), originalMetaData.getGlobalRuleMetaData(), originalMetaData.getProps());
        result.putDatabase(changedDatabase);
        return result;
    }

    public ShardingSphereDatabase createChangedDatabase(String databaseName, boolean isLoadSchemasFromRegisterCenter, SwitchingResource switchingResource, Collection<RuleConfiguration> ruleConfigs, MetaDataContexts originalMetaDataContext) throws SQLException {
        ShardingSphereDatabase database = originalMetaDataContext.getMetaData().getDatabase(databaseName);
        ResourceMetaData effectiveResourceMetaData = this.getEffectiveResourceMetaData(database, switchingResource);
        Collection toBeCreatedRuleConfigs = null == ruleConfigs ? database.getRuleMetaData().getConfigurations() : ruleConfigs;
        DatabaseConfiguration toBeCreatedDatabaseConfig = this.getDatabaseConfiguration(effectiveResourceMetaData, switchingResource, toBeCreatedRuleConfigs, originalMetaDataContext);
        return this.createChangedDatabase(database.getName(), isLoadSchemasFromRegisterCenter, toBeCreatedDatabaseConfig, originalMetaDataContext);
    }

    private ShardingSphereDatabase createChangedDatabase(String databaseName, boolean isLoadSchemasFromRegisterCenter, DatabaseConfiguration databaseConfig, MetaDataContexts originalMetaDataContext) throws SQLException {
        ConfigurationProperties props = originalMetaDataContext.getMetaData().getProps();
        DatabaseType protocolType = DatabaseTypeEngine.getProtocolType((DatabaseConfiguration)databaseConfig, (ConfigurationProperties)props);
        return isLoadSchemasFromRegisterCenter ? this.createFromRegisterCenter(databaseName, protocolType, databaseConfig, originalMetaDataContext) : ShardingSphereDatabaseFactory.create((String)databaseName, (DatabaseType)protocolType, (DatabaseConfiguration)databaseConfig, (ConfigurationProperties)props, (ComputeNodeInstanceContext)this.instanceContext);
    }

    private ShardingSphereDatabase createFromRegisterCenter(String databaseName, DatabaseType protocolType, DatabaseConfiguration databaseConfig, MetaDataContexts originalMetaDataContext) {
        Collection<ShardingSphereSchema> schemas = this.persistFacade.getDatabaseMetaDataFacade().getSchema().load(databaseName, protocolType);
        boolean persistSchemasEnabled = (Boolean)originalMetaDataContext.getMetaData().getProps().getValue((Enum)ConfigurationPropertyKey.PERSIST_SCHEMAS_TO_REPOSITORY_ENABLED);
        if (!persistSchemasEnabled) {
            for (ShardingSphereSchema schema : schemas) {
                if (!originalMetaDataContext.getMetaData().getDatabase(databaseName).containsSchema(schema.getName())) continue;
                ShardingSphereSchema originSchema = originalMetaDataContext.getMetaData().getDatabase(databaseName).getSchema(schema.getName());
                originSchema.getAllTables().forEach(arg_0 -> ((ShardingSphereSchema)schema).putTable(arg_0));
            }
        }
        return ShardingSphereDatabaseFactory.create((String)databaseName, (DatabaseType)protocolType, (DatabaseConfiguration)databaseConfig, (ComputeNodeInstanceContext)this.instanceContext, schemas);
    }

    private ResourceMetaData getEffectiveResourceMetaData(ShardingSphereDatabase database, SwitchingResource switchingResource) {
        Map<StorageNode, DataSource> storageNodes = this.getStorageNodes(database.getResourceMetaData().getDataSources(), switchingResource);
        Map<String, StorageUnit> storageUnits = this.getStorageUnits(database.getResourceMetaData().getStorageUnits(), switchingResource);
        return new ResourceMetaData(storageNodes, storageUnits);
    }

    private Map<StorageNode, DataSource> getStorageNodes(Map<StorageNode, DataSource> currentStorageNodes, SwitchingResource switchingResource) {
        return currentStorageNodes.entrySet().stream().filter(entry -> null == switchingResource || !switchingResource.getStaleDataSources().containsKey(entry.getKey())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (oldValue, currentValue) -> currentValue, () -> new LinkedHashMap(currentStorageNodes.size(), 1.0f)));
    }

    private Map<String, StorageUnit> getStorageUnits(Map<String, StorageUnit> currentStorageUnits, SwitchingResource switchingResource) {
        return currentStorageUnits.entrySet().stream().filter(entry -> null == switchingResource || !switchingResource.getStaleStorageUnitNames().contains(entry.getKey())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (oldValue, currentValue) -> currentValue, () -> new LinkedHashMap(currentStorageUnits.size(), 1.0f)));
    }

    private DatabaseConfiguration getDatabaseConfiguration(ResourceMetaData currentResourceMetaData, SwitchingResource switchingResource, Collection<RuleConfiguration> toBeCreatedRuleConfigs, MetaDataContexts metaDataContexts) {
        Map propsMap = null == switchingResource ? (Map)currentResourceMetaData.getStorageUnits().entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> ((StorageUnit)entry.getValue()).getDataSourcePoolProperties(), (oldValue, currentValue) -> oldValue, LinkedHashMap::new)) : switchingResource.getMergedDataSourcePoolPropertiesMap();
        boolean isInstanceConnectionEnabled = (Boolean)metaDataContexts.getMetaData().getTemporaryProps().getValue((Enum)TemporaryConfigurationPropertyKey.INSTANCE_CONNECTION_ENABLED);
        return new DataSourceProvidedDatabaseConfiguration(this.getMergedStorageNodeDataSources(currentResourceMetaData, switchingResource), toBeCreatedRuleConfigs, propsMap, isInstanceConnectionEnabled);
    }

    private Map<StorageNode, DataSource> getMergedStorageNodeDataSources(ResourceMetaData currentResourceMetaData, SwitchingResource switchingResource) {
        Map result = currentResourceMetaData.getDataSources();
        if (null != switchingResource && !switchingResource.getNewDataSources().isEmpty()) {
            result.putAll(switchingResource.getNewDataSources());
        }
        return result;
    }

    @Generated
    public MetaDataContextsFactory(MetaDataPersistFacade persistFacade, ComputeNodeInstanceContext instanceContext) {
        this.persistFacade = persistFacade;
        this.instanceContext = instanceContext;
    }
}

