/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.mode.metadata.changed;

import java.util.Optional;
import org.apache.shardingsphere.mode.event.DataChangedEvent;
import org.apache.shardingsphere.mode.node.path.NodePath;
import org.apache.shardingsphere.mode.node.path.engine.searcher.NodePathSearchCriteria;
import org.apache.shardingsphere.mode.node.path.engine.searcher.NodePathSearcher;
import org.apache.shardingsphere.mode.node.path.type.database.metadata.rule.DatabaseRuleItem;
import org.apache.shardingsphere.mode.node.path.type.database.metadata.rule.DatabaseRuleNodePath;
import org.apache.shardingsphere.mode.node.path.version.VersionNodePath;
import org.apache.shardingsphere.mode.node.rule.node.DatabaseRuleNode;
import org.apache.shardingsphere.mode.node.rule.node.DatabaseRuleNodeGenerator;

public final class RuleItemChangedNodePathBuilder {
    public Optional<DatabaseRuleNodePath> build(String databaseName, String path, DataChangedEvent.Type eventType) {
        Optional ruleType = NodePathSearcher.find((String)path, (NodePathSearchCriteria)DatabaseRuleNodePath.createRuleTypeSearchCriteria((String)databaseName));
        if (!ruleType.isPresent()) {
            return Optional.empty();
        }
        if (DataChangedEvent.Type.DELETED == eventType && DatabaseRuleNodePath.isRuleTypePath((String)databaseName, (String)path)) {
            return Optional.of(new DatabaseRuleNodePath(databaseName, (String)ruleType.get(), null));
        }
        DatabaseRuleNode databaseRuleNode = DatabaseRuleNodeGenerator.generate((String)((String)ruleType.get()));
        for (String each : databaseRuleNode.getNamedItems()) {
            Optional itemName = NodePathSearcher.find((String)path, (NodePathSearchCriteria)DatabaseRuleNodePath.createRuleItemNameSearchCriteria((String)databaseName, (String)databaseRuleNode.getRuleType(), (String)each));
            if (!itemName.isPresent()) continue;
            DatabaseRuleNodePath databaseRuleNodePath = new DatabaseRuleNodePath(databaseName, databaseRuleNode.getRuleType(), new DatabaseRuleItem(each, (String)itemName.get()));
            if (DataChangedEvent.Type.DELETED == eventType) {
                return DatabaseRuleNodePath.isNamedRuleItemPath((String)databaseName, (String)databaseRuleNode.getRuleType(), (String)each, (String)path) ? Optional.of(databaseRuleNodePath) : Optional.empty();
            }
            if (!new VersionNodePath((NodePath)databaseRuleNodePath).isActiveVersionPath(path)) continue;
            return Optional.of(databaseRuleNodePath);
        }
        for (String each : databaseRuleNode.getUniqueItems()) {
            DatabaseRuleNodePath databaseRuleNodePath = new DatabaseRuleNodePath(databaseName, databaseRuleNode.getRuleType(), new DatabaseRuleItem(each));
            if (DataChangedEvent.Type.DELETED == eventType) {
                return DatabaseRuleNodePath.isUniqueRuleItemPath((String)databaseName, (String)databaseRuleNode.getRuleType(), (String)each, (String)path) ? Optional.of(databaseRuleNodePath) : Optional.empty();
            }
            if (!new VersionNodePath((NodePath)databaseRuleNodePath).isActiveVersionPath(path)) continue;
            return Optional.of(databaseRuleNodePath);
        }
        return Optional.empty();
    }
}

