/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.mode.manager;

import java.sql.SQLException;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.shardingsphere.database.connector.core.type.DatabaseType;
import org.apache.shardingsphere.database.exception.core.exception.syntax.database.NoDatabaseSelectedException;
import org.apache.shardingsphere.database.exception.core.exception.syntax.database.UnknownDatabaseException;
import org.apache.shardingsphere.infra.config.props.ConfigurationProperties;
import org.apache.shardingsphere.infra.config.props.ConfigurationPropertyKey;
import org.apache.shardingsphere.infra.config.props.temporary.TemporaryConfigurationPropertyKey;
import org.apache.shardingsphere.infra.config.rule.RuleConfiguration;
import org.apache.shardingsphere.infra.database.DatabaseTypeEngine;
import org.apache.shardingsphere.infra.datasource.pool.props.domain.DataSourcePoolProperties;
import org.apache.shardingsphere.infra.exception.ShardingSpherePreconditions;
import org.apache.shardingsphere.infra.executor.kernel.ExecutorEngine;
import org.apache.shardingsphere.infra.instance.ComputeNodeInstanceContext;
import org.apache.shardingsphere.infra.instance.metadata.InstanceType;
import org.apache.shardingsphere.infra.metadata.ShardingSphereMetaData;
import org.apache.shardingsphere.infra.metadata.database.ShardingSphereDatabase;
import org.apache.shardingsphere.infra.metadata.database.resource.unit.StorageUnit;
import org.apache.shardingsphere.infra.metadata.database.rule.RuleMetaData;
import org.apache.shardingsphere.infra.metadata.database.schema.builder.GenericSchemaBuilder;
import org.apache.shardingsphere.infra.metadata.database.schema.builder.GenericSchemaBuilderMaterial;
import org.apache.shardingsphere.infra.metadata.database.schema.manager.GenericSchemaManager;
import org.apache.shardingsphere.infra.metadata.database.schema.model.ShardingSphereSchema;
import org.apache.shardingsphere.infra.metadata.statistics.ShardingSphereStatistics;
import org.apache.shardingsphere.infra.metadata.statistics.builder.ShardingSphereStatisticsFactory;
import org.apache.shardingsphere.infra.rule.builder.global.GlobalRulesBuilder;
import org.apache.shardingsphere.mode.exclusive.ExclusiveOperatorEngine;
import org.apache.shardingsphere.mode.manager.listener.ContextManagerLifecycleListenerFactory;
import org.apache.shardingsphere.mode.metadata.MetaDataContexts;
import org.apache.shardingsphere.mode.metadata.factory.MetaDataContextsFactory;
import org.apache.shardingsphere.mode.metadata.manager.MetaDataContextManager;
import org.apache.shardingsphere.mode.metadata.manager.resource.SwitchingResource;
import org.apache.shardingsphere.mode.persist.PersistServiceFacade;
import org.apache.shardingsphere.mode.spi.repository.PersistRepository;
import org.apache.shardingsphere.mode.state.StateContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ContextManager
implements AutoCloseable {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ContextManager.class);
    private final MetaDataContexts metaDataContexts;
    private final ComputeNodeInstanceContext computeNodeInstanceContext;
    private final ExclusiveOperatorEngine exclusiveOperatorEngine;
    private final ExecutorEngine executorEngine;
    private final MetaDataContextManager metaDataContextManager;
    private final PersistServiceFacade persistServiceFacade;
    private final StateContext stateContext;

    public ContextManager(MetaDataContexts metaDataContexts, ComputeNodeInstanceContext computeNodeInstanceContext, ExclusiveOperatorEngine exclusiveOperatorEngine, PersistRepository repository) {
        this.metaDataContexts = metaDataContexts;
        this.computeNodeInstanceContext = computeNodeInstanceContext;
        this.exclusiveOperatorEngine = exclusiveOperatorEngine;
        this.executorEngine = ExecutorEngine.createExecutorEngineWithSize((int)((Integer)metaDataContexts.getMetaData().getProps().getValue((Enum)ConfigurationPropertyKey.KERNEL_EXECUTOR_SIZE)));
        this.metaDataContextManager = new MetaDataContextManager(metaDataContexts, computeNodeInstanceContext, repository);
        this.persistServiceFacade = new PersistServiceFacade(repository, computeNodeInstanceContext.getModeConfiguration(), this.metaDataContextManager);
        this.stateContext = new StateContext(this.persistServiceFacade.getStateService().load());
        ContextManagerLifecycleListenerFactory.getListeners(this).forEach(each -> each.onInitialized(this));
    }

    public DatabaseType getDatabaseType() {
        Collection databases = this.metaDataContexts.getMetaData().getAllDatabases();
        return databases.stream().flatMap(each -> each.getResourceMetaData().getStorageUnits().values().stream()).findFirst().map(StorageUnit::getStorageType).orElseGet(DatabaseTypeEngine::getDefaultStorageType);
    }

    public Collection<String> getAllDatabaseNames() {
        return this.metaDataContexts.getMetaData().getAllDatabases().stream().map(ShardingSphereDatabase::getName).collect(Collectors.toList());
    }

    public ShardingSphereDatabase getDatabase(String name) {
        ShardingSpherePreconditions.checkNotEmpty((String)name, NoDatabaseSelectedException::new);
        ShardingSphereMetaData metaData = this.metaDataContexts.getMetaData();
        ShardingSpherePreconditions.checkState((boolean)metaData.containsDatabase(name), () -> new UnknownDatabaseException(name));
        return metaData.getDatabase(name);
    }

    public Map<String, StorageUnit> getStorageUnits(String databaseName) {
        return this.getDatabase(databaseName).getResourceMetaData().getStorageUnits();
    }

    public void reloadDatabase(ShardingSphereDatabase database) {
        try {
            MetaDataContexts reloadedMetaDataContexts = this.createMetaDataContexts(database);
            this.dropSchemas(database.getName(), reloadedMetaDataContexts.getMetaData().getDatabase(database.getName()), database);
            this.metaDataContexts.update(reloadedMetaDataContexts);
            this.metaDataContexts.getMetaData().getDatabase(database.getName()).getAllSchemas().forEach(each -> this.persistServiceFacade.getMetaDataFacade().getDatabaseMetaDataFacade().getSchema().alterByRefresh(database.getName(), (ShardingSphereSchema)each));
        }
        catch (SQLException ex) {
            log.error("Refresh database meta data: {} failed", (Object)database.getName(), (Object)ex);
        }
    }

    private MetaDataContexts createMetaDataContexts(ShardingSphereDatabase database) throws SQLException {
        Map<String, DataSourcePoolProperties> dataSourcePoolProps = this.persistServiceFacade.getMetaDataFacade().getDataSourceUnitService().load(database.getName());
        boolean isInstanceConnectionEnabled = (Boolean)this.metaDataContexts.getMetaData().getTemporaryProps().getValue((Enum)TemporaryConfigurationPropertyKey.INSTANCE_CONNECTION_ENABLED);
        SwitchingResource switchingResource = this.metaDataContextManager.getResourceSwitchManager().switchByAlterStorageUnit(database.getResourceMetaData(), dataSourcePoolProps, isInstanceConnectionEnabled);
        Collection<RuleConfiguration> ruleConfigs = this.persistServiceFacade.getMetaDataFacade().getDatabaseRuleService().load(database.getName());
        ShardingSphereDatabase changedDatabase = new MetaDataContextsFactory(this.persistServiceFacade.getMetaDataFacade(), this.computeNodeInstanceContext).createChangedDatabase(database.getName(), false, switchingResource, ruleConfigs, this.metaDataContexts);
        this.metaDataContexts.getMetaData().putDatabase(changedDatabase);
        ConfigurationProperties props = new ConfigurationProperties(this.persistServiceFacade.getMetaDataFacade().getPropsService().load());
        Collection<RuleConfiguration> globalRuleConfigs = this.persistServiceFacade.getMetaDataFacade().getGlobalRuleService().load();
        RuleMetaData changedGlobalMetaData = new RuleMetaData(GlobalRulesBuilder.buildRules(globalRuleConfigs, (Collection)this.metaDataContexts.getMetaData().getAllDatabases(), (ConfigurationProperties)props));
        ShardingSphereMetaData metaData = new ShardingSphereMetaData(this.metaDataContexts.getMetaData().getAllDatabases(), this.metaDataContexts.getMetaData().getGlobalResourceMetaData(), changedGlobalMetaData, props);
        MetaDataContexts result = new MetaDataContexts(metaData, ShardingSphereStatisticsFactory.create((ShardingSphereMetaData)metaData, (ShardingSphereStatistics)this.persistServiceFacade.getMetaDataFacade().getStatisticsService().load(metaData)));
        switchingResource.closeStaleDataSources();
        return result;
    }

    private void dropSchemas(String databaseName, ShardingSphereDatabase reloadDatabase, ShardingSphereDatabase currentDatabase) {
        GenericSchemaManager.getToBeDroppedSchemaNames((ShardingSphereDatabase)reloadDatabase, (ShardingSphereDatabase)currentDatabase).forEach(each -> this.persistServiceFacade.getMetaDataFacade().getDatabaseMetaDataFacade().getSchema().drop(databaseName, (String)each));
    }

    public void reloadSchema(ShardingSphereDatabase database, String schemaName, String dataSourceName) {
        try {
            ShardingSphereSchema reloadedSchema = this.loadSchema(database, schemaName, dataSourceName);
            if (reloadedSchema.getAllTables().isEmpty()) {
                database.dropSchema(schemaName);
                this.persistServiceFacade.getMetaDataFacade().getDatabaseMetaDataFacade().getSchema().drop(database.getName(), schemaName);
            } else {
                database.addSchema(reloadedSchema);
                this.persistServiceFacade.getMetaDataFacade().getDatabaseMetaDataFacade().getSchema().alterByRefresh(database.getName(), reloadedSchema);
            }
        }
        catch (SQLException ex) {
            log.error("Reload meta data of database: {} schema: {} with data source: {} failed", new Object[]{database.getName(), schemaName, dataSourceName, ex});
        }
    }

    private ShardingSphereSchema loadSchema(ShardingSphereDatabase database, String schemaName, String dataSourceName) throws SQLException {
        database.reloadRules();
        GenericSchemaBuilderMaterial material = new GenericSchemaBuilderMaterial(Collections.singletonMap(dataSourceName, (StorageUnit)database.getResourceMetaData().getStorageUnits().get(dataSourceName)), database.getRuleMetaData().getRules(), this.metaDataContexts.getMetaData().getProps(), schemaName);
        ShardingSphereSchema result = (ShardingSphereSchema)GenericSchemaBuilder.build((DatabaseType)database.getProtocolType(), (GenericSchemaBuilderMaterial)material).get(schemaName);
        this.persistServiceFacade.getMetaDataFacade().getDatabaseMetaDataFacade().getView().load(database.getName(), schemaName).forEach(arg_0 -> ((ShardingSphereSchema)result).putView(arg_0));
        return result;
    }

    public void reloadTable(ShardingSphereDatabase database, String schemaName, String tableName) {
        GenericSchemaBuilderMaterial material = new GenericSchemaBuilderMaterial(database.getResourceMetaData().getStorageUnits(), database.getRuleMetaData().getRules(), this.metaDataContexts.getMetaData().getProps(), schemaName);
        try {
            this.persistTable(database, schemaName, tableName, material);
        }
        catch (SQLException ex) {
            log.error("Reload table: {} meta data of database: {} schema: {} failed", new Object[]{tableName, database.getName(), schemaName, ex});
        }
    }

    public void reloadTable(ShardingSphereDatabase database, String schemaName, String dataSourceName, String tableName) {
        StorageUnit storageUnit = (StorageUnit)database.getResourceMetaData().getStorageUnits().get(dataSourceName);
        GenericSchemaBuilderMaterial material = new GenericSchemaBuilderMaterial(Collections.singletonMap(dataSourceName, storageUnit), database.getRuleMetaData().getRules(), this.metaDataContexts.getMetaData().getProps(), schemaName);
        try {
            this.persistTable(database, schemaName, tableName, material);
        }
        catch (SQLException ex) {
            log.error("Reload table: {} meta data of database: {} schema: {} with data source: {} failed", new Object[]{tableName, database.getName(), schemaName, dataSourceName, ex});
        }
    }

    private void persistTable(ShardingSphereDatabase database, String schemaName, String tableName, GenericSchemaBuilderMaterial material) throws SQLException {
        ShardingSphereSchema schema = GenericSchemaBuilder.build(Collections.singleton(tableName), (DatabaseType)database.getProtocolType(), (GenericSchemaBuilderMaterial)material).getOrDefault(schemaName, new ShardingSphereSchema(schemaName, database.getProtocolType()));
        if (schema.containsTable(tableName)) {
            this.persistServiceFacade.getMetaDataFacade().getDatabaseMetaDataFacade().getTable().persist(database.getName(), schemaName, Collections.singleton(schema.getTable(tableName)));
        } else {
            this.persistServiceFacade.getModeFacade().getMetaDataManagerService().dropTables(database, schemaName, Collections.singleton(tableName));
        }
    }

    public String getPreSelectedDatabaseName() {
        return InstanceType.JDBC == this.computeNodeInstanceContext.getInstance().getMetaData().getType() ? ((ShardingSphereDatabase)this.metaDataContexts.getMetaData().getAllDatabases().iterator().next()).getName() : null;
    }

    @Override
    public void close() {
        ContextManagerLifecycleListenerFactory.getListeners(this).forEach(each -> each.onDestroyed(this));
        this.executorEngine.close();
        this.metaDataContexts.getMetaData().close();
        this.persistServiceFacade.close();
    }

    @Generated
    public MetaDataContexts getMetaDataContexts() {
        return this.metaDataContexts;
    }

    @Generated
    public ComputeNodeInstanceContext getComputeNodeInstanceContext() {
        return this.computeNodeInstanceContext;
    }

    @Generated
    public ExclusiveOperatorEngine getExclusiveOperatorEngine() {
        return this.exclusiveOperatorEngine;
    }

    @Generated
    public ExecutorEngine getExecutorEngine() {
        return this.executorEngine;
    }

    @Generated
    public MetaDataContextManager getMetaDataContextManager() {
        return this.metaDataContextManager;
    }

    @Generated
    public PersistServiceFacade getPersistServiceFacade() {
        return this.persistServiceFacade;
    }

    @Generated
    public StateContext getStateContext() {
        return this.stateContext;
    }
}

