/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.mode.exclusive;

import java.sql.SQLException;
import lombok.Generated;
import org.apache.shardingsphere.mode.exclusive.ExclusiveOperation;
import org.apache.shardingsphere.mode.exclusive.ExclusiveOperatorContext;
import org.apache.shardingsphere.mode.exclusive.callback.ExclusiveOperationCallback;
import org.apache.shardingsphere.mode.exclusive.callback.ExclusiveOperationVoidCallback;
import org.apache.shardingsphere.mode.node.path.NodePath;
import org.apache.shardingsphere.mode.node.path.engine.generator.NodePathGenerator;
import org.apache.shardingsphere.mode.node.path.type.exclusive.ExclusiveOperationNodePath;

public final class ExclusiveOperatorEngine {
    private final ExclusiveOperatorContext context;

    public void operate(ExclusiveOperation operation, long timeoutMillis, ExclusiveOperationVoidCallback voidCallback) throws SQLException {
        this.operateWithResult(operation, timeoutMillis, () -> {
            voidCallback.execute();
            return null;
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T operateWithResult(ExclusiveOperation operation, long timeoutMillis, ExclusiveOperationCallback<T> callback) throws SQLException {
        String operationKey = NodePathGenerator.toPath((NodePath)new ExclusiveOperationNodePath(operation.getName()));
        if (this.context.start(operationKey, timeoutMillis)) {
            try {
                T t = callback.execute();
                return t;
            }
            finally {
                this.context.stop(operationKey);
            }
        }
        return null;
    }

    @Generated
    public ExclusiveOperatorEngine(ExclusiveOperatorContext context) {
        this.context = context;
    }
}

